// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import java.io.IOException;

import org.refcodes.exception.Trap;

/**
 * Thrown in case opening or accessing an open line (connection, junction, link)
 * caused problems. Usually a method similar to {@link Openable#open()} throws
 * such an exception.
 * <p>
 * ATTENTION: This {@link Exception} does not provide a dedicated
 * {@link ConnectionAccessor} as a {@link LinkComponent} does not necessary
 * provide dedicated connection information, it may be hard wired to another
 * software system's hot spot or similar with the option of opening or closing.
 * 
 * In order to provide compatibility with the Java APIs, this exception extends
 * the {@link IOException}. E.g. JAVA APIs throw an {@link IOException} upon
 * close, the {@link Closable} mixin throws an exception {@link OpenException}
 * upon failure which can be assigned to an {@link IOException} reference (e.g.
 * caught as an {@link IOException}).
 */
public class OpenException extends IOException implements Trap { // AbstractComponentException

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _errorCode = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public OpenException( String aMessage, String aErrorCode ) {
		super( aMessage );
		_errorCode = aErrorCode;
	}

	public OpenException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause );
		_errorCode = aErrorCode;
	}

	public OpenException( String message, Throwable cause ) {
		super( message, cause );
	}

	public OpenException( String message ) {
		super( message );
	}

	public OpenException( Throwable aCause, String aErrorCode ) {
		super( aCause );
		_errorCode = aErrorCode;
	}

	public OpenException( Throwable cause ) {
		super( cause );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ATTRIBUTES:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public String getErrorCode() {
		return _errorCode;
	}
}
