// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.mixin.TimeoutInMsAccessor;

/**
 * Thrown in case opening or accessing an open line (connection, junction, link)
 * caused timeout problems. Usually a method similar to {@link Openable#open()}
 * throws such an exception.
 * <p>
 * ATTENTION: This {@link Exception} does not provide a dedicated
 * {@link ConnectionAccessor} as a {@link LinkComponent} does not necessary
 * provide dedicated connection information, it may be hard wired to another
 * software system's hot spot or similar with the option of opening or closing.
 */
public class OpenTimeoutException extends OpenException implements TimeoutInMsAccessor {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private long _timeoutInMs;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public OpenTimeoutException( long aTimeoutInMs, String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
		_timeoutInMs = aTimeoutInMs;
	}

	public OpenTimeoutException( long aTimeoutInMs, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
		_timeoutInMs = aTimeoutInMs;
	}

	public OpenTimeoutException( long aTimeoutInMs, String message, Throwable cause ) {
		super( message, cause );
		_timeoutInMs = aTimeoutInMs;
	}

	public OpenTimeoutException( long aTimeoutInMs, String message ) {
		super( message );
		_timeoutInMs = aTimeoutInMs;
	}

	public OpenTimeoutException( long aTimeoutInMs, Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
		_timeoutInMs = aTimeoutInMs;
	}

	public OpenTimeoutException( long aTimeoutInMs, Throwable cause ) {
		super( cause );
		_timeoutInMs = aTimeoutInMs;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public long getTimeoutInMs() {
		return _timeoutInMs;
	}
}
