// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.component.ComponentRuntimeException.ComponentHandleRuntimeException;

/**
 * This exception is thrown in case a handle was provided which was unknown to
 * the invoked component.
 */
public class UnknownHandleRuntimeException extends ComponentHandleRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public UnknownHandleRuntimeException( Object aHandle, String aMessage, String aErrorCode ) {
		super( aHandle, aMessage, aErrorCode );
	}

	public UnknownHandleRuntimeException( Object aHandle, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aHandle, aMessage, aCause, aErrorCode );
	}

	public UnknownHandleRuntimeException( Object aHandle, String message, Throwable cause ) {
		super( aHandle, message, cause );
	}

	public UnknownHandleRuntimeException( Object aHandle, String message ) {
		super( aHandle, message );
	}

	public UnknownHandleRuntimeException( Object aHandle, Throwable aCause, String aErrorCode ) {
		super( aHandle, aCause, aErrorCode );
	}

	public UnknownHandleRuntimeException( Object aHandle, Throwable cause ) {
		super( aHandle, cause );
	}
}