/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.ArgsParserImpl;
import org.refcodes.console.Condition;
import org.refcodes.console.ConsoleSugar;
import org.refcodes.console.Option;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.Switch;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontType;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class OptionalConditionTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testOptionalEdgeCase() {
        Option theWidth = ConsoleSugar.intOption((String)"-w", (String)"--width", (String)"width", (String)"Sets the console width");
        Option thePortOption = ConsoleSugar.intOption((String)"-p", (String)"--port", (String)"port", (String)"Sets the port for the server");
        Option theMaxConns = ConsoleSugar.intOption((String)"-c", (String)"--connections", (String)"connections", (String)"Sets the number of max. connections");
        Option theUsername = ConsoleSugar.stringOption((String)"-u", (String)"--user", (String)"username", (String)"The username for HTTP Basic-Authentication");
        Option theSecret = ConsoleSugar.stringOption((String)"-s", (String)"--secret", (String)"secret", (String)"The password for HTTP Basic-Authentication");
        Switch theSysInfo = ConsoleSugar.switsh(null, (String)"--sysinfo", (String)"Shows some system information");
        Option theMgmPortOption = ConsoleSugar.intOption((String)"-m", (String)"--management-port", (String)"management-port", (String)"The management-port on which to listen for shutdown...");
        Switch theHelp = ConsoleSugar.helpSwitch((String)"Shows this help");
        Condition theRoot = ConsoleSugar.optional((Syntaxable[])new Syntaxable[]{ConsoleSugar.xor((Syntaxable[])new Syntaxable[]{ConsoleSugar.optional((Syntaxable[])new Syntaxable[]{thePortOption, theMaxConns, ConsoleSugar.and((Syntaxable[])new Syntaxable[]{theUsername, theSecret}), theWidth, theMgmPortOption}), ConsoleSugar.optional((Syntaxable[])new Syntaxable[]{ConsoleSugar.xor((Syntaxable[])new Syntaxable[]{theHelp, theSysInfo})})})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl(theRoot);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.withName("TinyRestful").withTitle("TINYRESTFUL").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theArgsParser.withBannerFont((Font)new FontImpl(FontType.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theArgsParser.withDescription("Tiny evil RESTful server. TinyRestfulServer makes heavy use of the REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        String[] args = new String[]{"-p", "8080", "--sysinfo"};
        try {
            theArgsParser.evalArgs(args);
        }
        catch (AmbiguousArgsException | ParseArgsException | SuperfluousArgsException | UnknownArgsException e) {
            LOGGER.info(new VerboseTextBuilderImpl().withElements((Object[])e.getArgs()).toString());
            LOGGER.info(e.getMessage());
            Assertions.assertEquals((int)3, (int)e.getArgs().length);
        }
    }
}

