// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cryptography.tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.refcodes.cryptography.consts.CryptographyConsts;
import org.refcodes.cryptography.utils.CryptographyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;

public class CryptographyUtilityTest {

	private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.getInstance().createInstance();

	@Test
	public void testCryptographyUtility() {
		String eCipherUid, eCipher, eEncryptedMockText, eMockText;
		for ( int i = 0; i < 50; i++ ) {
			eCipherUid = CryptographyUtility.createCipherUid();
			eCipher = CryptographyUtility.createCipher();
			assertEquals( eCipherUid.length(), CryptographyUtility.CIPHER_UID_LENGTH );
			assertEquals( eCipher.length(), CryptographyUtility.CIPHER_LENGTH );
			LOGGER.info( eCipherUid + " --> " + eCipher );

			eEncryptedMockText = eCipherUid + CryptographyConsts.CIPHER_UID_DELIMITER + i;
			LOGGER.info( eEncryptedMockText + " = " + (CryptographyUtility.hasEncryptionPattern( eEncryptedMockText ) ? "Fits encryped pattern" : "Plain") );
			assertTrue( CryptographyUtility.hasEncryptionPattern( eEncryptedMockText ) );
			eMockText = eCipherUid + i;
			LOGGER.info( eMockText + " = " + (CryptographyUtility.hasEncryptionPattern( eMockText ) ? "Fits encryped pattern" : "Plain") );
			assertFalse( CryptographyUtility.hasEncryptionPattern( eMockText ) );
			eMockText = i + eCipherUid + CryptographyConsts.CIPHER_UID_DELIMITER;
			LOGGER.info( eMockText + " = " + (CryptographyUtility.hasEncryptionPattern( eMockText ) ? "Fits encryped pattern" : "Plain") );
			assertFalse( CryptographyUtility.hasEncryptionPattern( eMockText ) );
		}
	}
}
