// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

import static org.junit.Assert.*;

import org.junit.Test;
import org.refcodes.graphical.BoxBorderMode;

/**
 * @author steiner
 *
 */
public class BoxBorderModeTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// @formatter:off
	private boolean [][] BOX_BORDERS = new boolean [][] {
		{ false, false, false, false},
		{ false, false, false,  true},
		{ false, false,  true, false},
		{ false, false,  true,  true},
		{ false,  true, false, false},
		{ false,  true, false,  true},
		{ false,  true,  true, false},
		{ false,  true,  true,  true},
		{  true, false, false, false},
		{  true, false, false,  true},
		{  true, false,  true, false},
		{  true, false,  true,  true},
		{  true,  true, false, false},
		{  true,  true, false,  true},
		{  true,  true,  true, false},
		{  true,  true,  true,  true}
	};
	// @formatter:on

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testBoxBorders() {
		String eName;
		BoxBorderMode eBox;
		for ( boolean[] eBorders : BOX_BORDERS ) {
			if ( !eBorders[0] && !eBorders[1] && !eBorders[2] && !eBorders[3] ) {
				eName = "NONE";
			}
			else {
				eName = "";
				if ( eBorders[0] ) eName += "TOP";
				if ( eBorders[1] ) eName += (eName.length() > 0 ? "_" : "") + "RIGHT";
				if ( eBorders[2] ) eName += (eName.length() > 0 ? "_" : "") + "BOTTOM";
				if ( eBorders[3] ) eName += (eName.length() > 0 ? "_" : "") + "LEFT";
			}
			eBox = BoxBorderMode.fromBoxBorders( eBorders[0], eBorders[1], eBorders[2], eBorders[3] );
			System.out.println( "Expecting <" + eName + "> to evaluate to <" + eBox.name() + "> ..." );
			assertEquals( eName, eBox.name() );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
