// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a {@link FieldDimension} property.
 */
public interface FieldDimension extends FieldHeightAccessor, FieldWidthAccessor, FieldGapAccessor {

	/**
	 * The Interface FieldDimensionMutator.
	 */
	public interface FieldDimensionMutator extends FieldHeightMutator, FieldWidthMutator, FieldGapMutator {

		/**
		 * Sets the field dimension.
		 *
		 * @param aFieldWidth the field width
		 * @param aFieldHeight the field height
		 */
		void setFieldDimension( int aFieldWidth, int aFieldHeight );

		/**
		 * Sets the field dimension.
		 *
		 * @param aFieldWidth the field width
		 * @param aFieldHeight the field height
		 * @param aGap the gap
		 */
		void setFieldDimension( int aFieldWidth, int aFieldHeight, int aGap );

		/**
		 * Sets the field dimension.
		 *
		 * @param aField the new field dimension
		 */
		void setFieldDimension( FieldDimension aField );

		/**
		 * Sets the field dimension.
		 *
		 * @param aDimension the new field dimension
		 */
		void setFieldDimension( Dimension aDimension );
	}

	/**
	 * The Interface FieldDimensionBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface FieldDimensionBuilder<B extends FieldDimensionBuilder<B>> extends FieldWidthBuilder<B>, FieldHeightBuilder<B>, FieldGapBuilder<B> {

		/**
		 * With field dimension.
		 *
		 * @param aFieldWidth the field width
		 * @param aFieldHeight the field height
		 * @return the b
		 */
		B withFieldDimension( int aFieldWidth, int aFieldHeight );

		/**
		 * With field dimension.
		 *
		 * @param aFieldWidth the field width
		 * @param aFieldHeight the field height
		 * @param aGap the gap
		 * @return the b
		 */
		B withFieldDimension( int aFieldWidth, int aFieldHeight, int aGap );

		/**
		 * With field dimension.
		 *
		 * @param aField the field
		 * @return the b
		 */
		B withFieldDimension( FieldDimension aField );

		/**
		 * With field dimension.
		 *
		 * @param aDimension the dimension
		 * @return the b
		 */
		B withFieldDimension( Dimension aDimension );
	}

	/**
	 * The Interface FieldDimensionProperty.
	 */
	public interface FieldDimensionProperty extends FieldDimension, FieldDimensionMutator, FieldWidthProperty, FieldHeightProperty, FieldGapProperty {}

	/**
	 * The Interface FieldDimensionPropertyBuilder.
	 */
	public interface FieldDimensionPropertyBuilder extends FieldDimensionProperty, FieldDimensionBuilder<FieldDimensionPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aFieldDimensionA the field dimension A
	 * @param aFieldDimensionB the field dimension B
	 * @return true, if successful
	 */
	static boolean equals( FieldDimension aFieldDimensionA, FieldDimension aFieldDimensionB ) {
		return aFieldDimensionA.getFieldWidth() == aFieldDimensionB.getFieldWidth() && aFieldDimensionA.getFieldHeight() == aFieldDimensionB.getFieldHeight();
	}

}
