// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class RgbPixelImpl.
 *
 * @author steiner
 */
public class RgbPixelImpl implements RgbPixel {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private int _alphaPortion = 0;

	private int _redPortion = 0;

	private int _greenPortion = 0;

	private int _bluePortion = 0;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new rgb pixel impl.
	 */
	public RgbPixelImpl() {};

	/**
	 * Instantiates a new rgb pixel impl.
	 *
	 * @param aAlphaPortion the alpha portion
	 * @param aRedPortion the red portion
	 * @param aGreenPortion the green portion
	 * @param aBluePortion the blue portion
	 */
	public RgbPixelImpl( int aAlphaPortion, int aRedPortion, int aGreenPortion, int aBluePortion ) {
		_alphaPortion = aAlphaPortion;
		_redPortion = aRedPortion;
		_greenPortion = aGreenPortion;
		_bluePortion = aBluePortion;
	}

	/**
	 * Instantiates a new rgb pixel impl.
	 *
	 * @param aRgbValue the rgb value
	 */
	public RgbPixelImpl( int aRgbValue ) {
		setRgbValue( aRgbValue );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getAlphaPortion() {
		return _alphaPortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getRedPortion() {
		return _redPortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGreenPortion() {
		return _greenPortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getBluePortion() {
		return _bluePortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int toRgbValue() {
		return GraphicalUtility.toRgb( _alphaPortion, _redPortion, _greenPortion, _bluePortion );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRgbValue( int aRgbValue ) {
		_alphaPortion = GraphicalUtility.toAlpha( aRgbValue );
		_redPortion = GraphicalUtility.toRed( aRgbValue );
		_greenPortion = GraphicalUtility.toGreen( aRgbValue );
		_bluePortion = GraphicalUtility.toBlue( aRgbValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAlphaPortion( int aAlphaPortion ) {
		_alphaPortion = aAlphaPortion;

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRedPortion( int aRedPortion ) {
		_redPortion = aRedPortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGreenPortion( int aGreenPortion ) {
		_greenPortion = aGreenPortion;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBluePortion( int aBluePortion ) {
		_bluePortion = aBluePortion;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
