// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class ViewportDimensionImpl.
 *
 * @author steiner
 */
public class ViewportDimensionImpl implements ViewportDimension {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _width;

	protected int _height;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new viewport dimension impl.
	 */
	protected ViewportDimensionImpl() {}

	/**
	 * Instantiates a new viewport dimension impl.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 */
	public ViewportDimensionImpl( int aWidth, int aHeight ) {
		_width = aWidth;
		_height = aHeight;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportWidth() {
		return _width;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportHeight() {
		return _height;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + " x " + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class ViewportDimensionPropertyBuilderImpl.
	 */
	public static class ViewportDimensionPropertyBuilderImpl extends ViewportDimensionImpl implements ViewportDimensionPropertyBuilderBuilder {

		/**
		 * Instantiates a new viewport dimension property builder impl.
		 */
		public ViewportDimensionPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new viewport dimension property builder impl.
		 *
		 * @param aWidth the width
		 * @param aHeight the height
		 */
		public ViewportDimensionPropertyBuilderImpl( int aWidth, int aHeight ) {
			super( aWidth, aHeight );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportWidth( int aWidth ) {
			_width = aWidth;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportDimensionPropertyBuilderImpl withViewportWidth( int aWidth ) {
			_width = aWidth;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportHeight( int aHeight ) {
			_height = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportDimensionPropertyBuilderImpl withViewportHeight( int aHeight ) {
			_height = aHeight;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportDimensionPropertyBuilderImpl withViewportDimension( int aWidth, int aHeight ) {
			setViewportDimension( aWidth, aHeight );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportDimensionPropertyBuilderImpl withViewportDimension( ViewportDimension aDimension ) {
			setViewportDimension( aDimension );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportDimension( int aWidth, int aHeight ) {
			_width = aWidth;
			_height = aHeight;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportDimension( ViewportDimension aDimension ) {
			_width = aDimension.getViewportWidth();
			_height = aDimension.getViewportHeight();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportDimensionPropertyBuilderImpl withViewportDimension( Dimension aDimension ) {
			setViewportDimension( aDimension.getWidth(), aDimension.getHeight() );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportDimension( Dimension aDimension ) {
			_width = aDimension.getWidth();
			_height = aDimension.getHeight();
		}
	}
}