// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * The Class ViewportOffsetImpl.
 *
 * @author steiner
 */
public class ViewportOffsetImpl implements ViewportOffset {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected int _offsetX;

	protected int _offsetY;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new viewport offset impl.
	 */
	protected ViewportOffsetImpl() {}

	/**
	 * Instantiates a new viewport offset impl.
	 *
	 * @param aOffsetX the offset X
	 * @param aOffsetY the offset Y
	 */
	public ViewportOffsetImpl( int aOffsetX, int aOffsetY ) {
		_offsetX = aOffsetX;
		_offsetY = aOffsetY;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportOffsetX() {
		return _offsetX;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportOffsetY() {
		return _offsetY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _offsetX + " x " + _offsetY + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class ViewportOffsetPropertyBuilderImpl.
	 */
	public static class ViewportOffsetPropertyBuilderImpl extends ViewportOffsetImpl implements ViewportOffsetPropertyBuilder {

		/**
		 * Instantiates a new viewport offset property builder impl.
		 */
		public ViewportOffsetPropertyBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new viewport offset property builder impl.
		 *
		 * @param aOffsetX the offset X
		 * @param aOffsetY the offset Y
		 */
		public ViewportOffsetPropertyBuilderImpl( int aOffsetX, int aOffsetY ) {
			super( aOffsetX, aOffsetY );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffsetX( int aOffsetX ) {
			_offsetX = aOffsetX;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffsetX( int aOffsetX ) {
			_offsetX = aOffsetX;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffsetY( int aOffsetY ) {
			_offsetY = aOffsetY;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffsetY( int aOffsetY ) {
			_offsetY = aOffsetY;
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffset( int aOffsetX, int aOffsetY ) {
			setViewportOffset( aOffsetX, aOffsetY );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffset( ViewportOffset aOffset ) {
			setViewportOffset( aOffset );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffset( int aOffsetX, int aOffsetY ) {
			_offsetX = aOffsetX;
			_offsetY = aOffsetY;

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffset( ViewportOffset aOffset ) {
			_offsetX = aOffset.getViewportOffsetX();
			_offsetY = aOffset.getViewportOffsetY();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffset( Offset aOffset ) {
			setViewportOffset( aOffset.getOffsetX(), aOffset.getOffsetY() );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffset( Offset aOffset ) {
			_offsetX = aOffset.getOffsetX();
			_offsetY = aOffset.getOffsetY();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public ViewportOffsetPropertyBuilderImpl withViewportOffset( Position aOffset ) {
			setViewportOffset( aOffset );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void setViewportOffset( Position aOffset ) {
			_offsetX = aOffset.getPositionX();
			_offsetY = aOffset.getPositionY();
		}
	}
}