// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import org.refcodes.component.Closable;
import org.refcodes.component.OpenException;

/**
 * (as {@link java.io.OutputStream} does not provide some useful *interface*)
 * 
 * @see java.io.OutputStream
 */
public interface ByteDatagramOutputStream extends Closable {

	/**
	 * Write.
	 *
	 * @param b the b
	 * @throws OpenException the open exception
	 */
	void write( int b ) throws OpenException;

	/**
	 * Write.
	 *
	 * @param b the b
	 * @throws OpenException the open exception
	 */
	void write( byte b[] ) throws OpenException;

	/**
	 * Write.
	 *
	 * @param b the b
	 * @param off the off
	 * @param len the len
	 * @throws OpenException the open exception
	 */
	void write( byte b[], int off, int len ) throws OpenException;

	/**
	 * Flush.
	 *
	 * @throws OpenException the open exception
	 */
	void flush() throws OpenException;

	// void close() throws CloseException;
}