// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

import org.refcodes.component.ConnectionComponent.ConnectionAutomaton;

/**
 * The {@link ConnectionTransceiver} defines the {@link DatagramTransceiver}
 * functionality set on top of a connection (as of the
 * {@link ConnectionAutomaton}).
 *
 * @param <DATA> The type of the datagram to be operated with.
 * @param <CON> The type of the connection to be used.
 */
public interface ConnectionTransceiver<DATA extends Serializable, CON> extends ConnectionSender<DATA, CON>, ConnectionReceiver<DATA, CON>, Transceiver<DATA>, ConnectionAutomaton<CON> {}
