// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.InputStream;
import java.io.OutputStream;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;

/**
 * The Class PrefetchBidirectionalStreamByteTransceiverImpl.
 *
 * @author steiner
 */
public class PrefetchBidirectionalStreamByteTransceiverImpl implements ByteTransceiver {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private BidirectionalStreamConnectionByteTransceiver _transceiver;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new prefetch bidirectional stream byte transceiver impl.
	 *
	 * @param aInputStream the input stream
	 * @param aOutputStream the output stream
	 * @throws OpenException the open exception
	 */
	public PrefetchBidirectionalStreamByteTransceiverImpl( InputStream aInputStream, OutputStream aOutputStream ) throws OpenException {
		_transceiver = new PrefetchBidirectionalStreamConnectionByteTransceiverImpl();
		_transceiver.open( aInputStream, aOutputStream );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosed() {
		return _transceiver.isClosed();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isOpened() {
		return _transceiver.isOpened();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasDatagram() throws OpenException {
		return _transceiver.hasDatagram();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public byte[] readDatagrams() throws OpenException, InterruptedException {
		return _transceiver.readDatagrams();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ConnectionStatus getConnectionStatus() {
		return _transceiver.getConnectionStatus();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void releaseAll() {
		_transceiver.releaseAll();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws CloseException {
		_transceiver.close();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public byte readDatagram() throws OpenException, InterruptedException {
		return _transceiver.readDatagram();
	}

	/**
	 * Write datagrams.
	 *
	 * @param aDatagram the datagram
	 * @throws OpenException the open exception
	 */
	@Override
	public void writeDatagrams( byte[] aDatagram ) throws OpenException {
		_transceiver.writeDatagrams( aDatagram );
	}

	/**
	 * Write datagrams.
	 *
	 * @param aDatagram the datagram
	 * @param aOffset the offset
	 * @param aLength the length
	 * @throws OpenException the open exception
	 */
	@Override
	public void writeDatagrams( byte[] aDatagram, int aOffset, int aLength ) throws OpenException {
		_transceiver.writeDatagrams( aDatagram, aOffset, aLength );
	}

	/**
	 * Write datagram.
	 *
	 * @param aDatagram the datagram
	 * @throws OpenException the open exception
	 */
	@Override
	public void writeDatagram( byte aDatagram ) throws OpenException {
		_transceiver.writeDatagram( aDatagram );
	}

	/**
	 * Flush.
	 *
	 * @throws OpenException the open exception
	 */
	@Override
	public void flush() throws OpenException {
		_transceiver.flush();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosable() {
		return _transceiver.isClosable();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
