package org.refcodes.io;

import java.util.List;

import org.refcodes.component.OpenException;

/**
 * The Class ShortArrayReceiverImpl.
 */
public class ShortArrayReceiverImpl extends AbstractShortReceiver {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new short array receiver impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ShortArrayReceiverImpl( short[] aDatagrams ) {
		super( aDatagrams.length );
		try {
			open();
			pushDatagrams( aDatagrams );
		}
		catch ( OpenException ignore ) {}
	}

	/**
	 * Instantiates a new short array receiver impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ShortArrayReceiverImpl( List<Short> aDatagrams ) {
		this( toPrimitiveType( aDatagrams.toArray( new Short[aDatagrams.size()] ) ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	private static short[] toPrimitiveType( Short[] aShorts ) {
		if ( aShorts == null ) return null;
		short[] thePrimitives = new short[aShorts.length];
		for ( int i = 0; i < aShorts.length; i++ ) {
			thePrimitives[i] = aShorts[i].shortValue();
		}
		return thePrimitives;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
