/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.refcodes.io.ZipFileInputStreamImpl;

public class ZipFileOutputStreamImpl
extends BufferedOutputStream {
    public ZipFileOutputStreamImpl(File parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileOutputStreamImpl(String parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileOutputStreamImpl(String pathname) throws ZipException, FileNotFoundException, IOException {
        this(new File(pathname));
    }

    public ZipFileOutputStreamImpl(URI uri) throws ZipException, FileNotFoundException, IOException {
        this(new File(uri));
    }

    public ZipFileOutputStreamImpl(File aFile) throws ZipException, FileNotFoundException, IOException {
        super(ZipFileOutputStreamImpl.toOutputStream(aFile));
    }

    protected static OutputStream toOutputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        String theUnZipFileName = ZipFileOutputStreamImpl.toFileNameFromZip(aFile.getName());
        if (theUnZipFileName != null) {
            BufferedOutputStream theFileOutputStream = new BufferedOutputStream(new FileOutputStream(aFile));
            ZipOutputStream theZipOutputStream = new ZipOutputStream(theFileOutputStream);
            ZipEntry theZipEntry = new ZipEntry(theUnZipFileName);
            theZipOutputStream.putNextEntry(theZipEntry);
            return theZipOutputStream;
        }
        return new BufferedOutputStream(new FileOutputStream(aFile));
    }

    protected static String toFileNameFromZip(String aZipFileName) {
        return ZipFileInputStreamImpl.toFileNameFromZip(aZipFileName);
    }
}

