// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

import org.refcodes.component.OpenException;

/**
 * The {@link DatagramConsumer} is used to send datagrams in a unified way.
 *
 * @param <DATA> The type of the datagram to be operated with. In case you wish
 *        to use array types, you might better use the {@link BlockSender} type.
 */
@FunctionalInterface
public interface DatagramConsumer<DATA extends Serializable> {

	/**
	 * Writes (sends) a datagram to a listening {@link DatagramReceiver}.
	 * 
	 * @param aDatagram The datagram to be pushed to the receiving
	 *        {@link DatagramConsumer}.
	 * 
	 * @throws OpenException Thrown in case opening or accessing an open line
	 *         (connection, junction, link) caused problems.
	 */
	void writeDatagram( DATA aDatagram ) throws OpenException;

}
