// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;

/**
 * Implementation of the {@link LoopbackReceiver} interface.
 * 
 * @param <DATA> The type of the datagram to be operated with.
 */
public class LoopbackReceiverImpl<DATA extends Serializable> extends AbstractReceiver<DATA> implements LoopbackReceiver<DATA> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private LoopbackSender<DATA> _loopbackSender;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new loopback receiver impl.
	 */
	public LoopbackReceiverImpl() {
		super();
	}

	/**
	 * Instantiates a new loopback receiver impl.
	 *
	 * @param aCapacity the capacity
	 */
	public LoopbackReceiverImpl( int aCapacity ) {
		super( aCapacity );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isOpenable( LoopbackSender<DATA> aLoopbackSender ) {
		return super.isOpenable() && aLoopbackSender != null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized void open( LoopbackSender<DATA> aLoopbackSender ) throws OpenException {
		if ( isOpened() ) {
			if ( _loopbackSender == aLoopbackSender && _loopbackSender.isOpened() ) {
				return;
			}
			throw new OpenException( "Unable to open the connection is is is ALREADY OPEN; connection status is " + getConnectionStatus() + "." );
		}
		super.open();
		_loopbackSender = aLoopbackSender;
		if ( _loopbackSender.isOpenable( this ) ) {
			_loopbackSender.open( this );
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void pushDatagram( DATA aDatagram ) throws OpenException {
		super.pushDatagram( aDatagram );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void pushDatagrams( DATA[] aDatagrams ) throws OpenException {
		super.pushDatagrams( aDatagrams );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void pushDatagrams( DATA[] aDatagrams, int aOffset, int aLength ) throws OpenException {
		super.pushDatagrams( aDatagrams, aOffset, aLength );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized void close() throws CloseException {
		super.close();
		if ( _loopbackSender != null && !_loopbackSender.isClosed() ) {
			_loopbackSender.close();
			_loopbackSender = null;
		}
	}
}
