// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;

/**
 * The Class PrefetchBidirectionalStreamTransceiverImpl.
 *
 * @author steiner
 * @param <DATA> the generic type
 */
public class PrefetchBidirectionalStreamTransceiverImpl<DATA extends Serializable> implements Transceiver<DATA> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private BidirectionalStreamConnectionTransceiver<DATA> _transceiver;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new prefetch bidirectional stream transceiver impl.
	 *
	 * @param aInputStream the input stream
	 * @param aOutputStream the output stream
	 * @throws OpenException the open exception
	 */
	public PrefetchBidirectionalStreamTransceiverImpl( InputStream aInputStream, OutputStream aOutputStream ) throws OpenException {
		_transceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl<DATA>();
		_transceiver.open( aInputStream, aOutputStream );
	}

	/**
	 * Instantiates a new prefetch bidirectional stream transceiver impl.
	 *
	 * @param aInputStream the input stream
	 * @param aOutputStream the output stream
	 * @param aExecutorService the executor service
	 * @throws OpenException the open exception
	 */
	public PrefetchBidirectionalStreamTransceiverImpl( InputStream aInputStream, OutputStream aOutputStream, ExecutorService aExecutorService ) throws OpenException {
		_transceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl<DATA>( aExecutorService );
		_transceiver.open( aInputStream, aOutputStream );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosed() {
		return _transceiver.isClosed();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isOpened() {
		return _transceiver.isOpened();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasDatagram() throws OpenException {
		return _transceiver.hasDatagram();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DATA[] readDatagrams() throws OpenException, InterruptedException {
		return _transceiver.readDatagrams();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ConnectionStatus getConnectionStatus() {
		return _transceiver.getConnectionStatus();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void releaseAll() {
		_transceiver.releaseAll();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws CloseException {
		_transceiver.close();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DATA readDatagram() throws OpenException, InterruptedException {
		return _transceiver.readDatagram();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( DATA[] aDatagram ) throws OpenException {
		_transceiver.writeDatagrams( aDatagram );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( DATA[] aDatagram, int aOffset, int aLength ) throws OpenException {
		_transceiver.writeDatagrams( aDatagram, aOffset, aLength );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagram( DATA aDatagram ) throws OpenException {
		_transceiver.writeDatagram( aDatagram );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void flush() throws OpenException {
		_transceiver.flush();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isClosable() {
		return _transceiver.isClosable();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
