/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.ByteReceiver;

public abstract class AbstractInputStreamByteReceiver
extends AbstractConnectableAutomaton
implements ByteReceiver {
    private LinkedList<Byte> _datagramQueue = new LinkedList();
    private InputStream _inputStream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDatagram() throws OpenException {
        if (this.isClosed()) {
            return false;
        }
        if (!this._datagramQueue.isEmpty()) {
            return true;
        }
        try {
            int theWord = this._inputStream.read();
            if (theWord == -1) {
                this.close();
                LinkedList<Byte> linkedList = this._datagramQueue;
                synchronized (linkedList) {
                    this._datagramQueue.notifyAll();
                }
                return false;
            }
            this._datagramQueue.add((byte)(theWord & 0xFF));
            return true;
        }
        catch (CloseException e) {
            LinkedList<Byte> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
        }
        catch (IOException ioe) {
            if (this.isClosed()) {
                return false;
            }
            LinkedList<Byte> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            try {
                if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)ioe)) {
                    super.close();
                } else {
                    this.close();
                }
            }
            catch (CloseException e) {
                throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
            }
            throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)ioe);
        }
    }

    @Override
    public byte readDatagram() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        if (!this.hasDatagram()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        Byte theDatagram = this._datagramQueue.poll();
        while (theDatagram == null) {
            if (this.hasDatagram()) continue;
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        return theDatagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        LinkedList<Byte> linkedList = this._datagramQueue;
        synchronized (linkedList) {
            this._datagramQueue.notifyAll();
        }
    }

    public synchronized void close() throws CloseException {
        block3: {
            if (!this.isClosed()) {
                super.close();
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)e)) break block3;
                    throw new CloseException("Unable to close receiver, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
                }
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        this._inputStream = aInputStream;
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected boolean isOpenable(InputStream aInputStream) {
        if (aInputStream == null) {
            return false;
        }
        return !this.isOpened();
    }
}

