// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.logger.alt.slf4j.impls;

import java.util.Properties;

import org.refcodes.data.consts.DelimeterConsts;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.consts.RuntimeLoggerConsts;
import org.refcodes.logger.factories.RuntimeLoggerFactory;
import org.refcodes.runtime.utils.RuntimeUtility;
import org.slf4j.LoggerFactory;

/**
 * @author steiner
 *
 */
public class Slf4jRuntimeLoggerFactoryImpl implements RuntimeLoggerFactory {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	protected Slf4jRuntimeLoggerFactoryImpl() {}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RuntimeLogger createInstance() {
		// ---------------------------------------------------------------------
		// ATTENTION: As the StackTraceElement caller array is evaluated, we 
		// must not delegate this call to one "master" implementation as this 
		// will falsify the actual origin of this factory call.
		// ---------------------------------------------------------------------
		String className = RuntimeUtility.getCallerStackTraceElement( Slf4jRuntimeLoggerFactoryImpl.class ).getClassName();
		return new Slf4jRuntimeLoggerImpl( LoggerFactory.getLogger( className ) );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	// ---------------------------------------------------------------------
	// ATTENTION: As the StackTraceElement caller array is evaluated, we 
	// must not delegate this call to one "master" implementation as this 
	// will falsify the actual origin of this factory call.
	// ---------------------------------------------------------------------
	public RuntimeLogger createInstance( Properties aProperties ) {
		return new Slf4jRuntimeLoggerImpl( LoggerFactory.getLogger( RuntimeUtility.getCallerStackTraceElement( Slf4jRuntimeLoggerFactoryImpl.class ).getClassName() ) );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	// ---------------------------------------------------------------------
	// ATTENTION: As the StackTraceElement caller array is evaluated, we 
	// must not delegate this call to one "master" implementation as this 
	// will falsify the actual origin of this factory call.
	// ---------------------------------------------------------------------
	public RuntimeLogger createInstance( String aIdentifier ) {
		return new Slf4jRuntimeLoggerImpl( LoggerFactory.getLogger( aIdentifier ) );
	}

	/**
	 * {@inheritDoc}
	 * 
	 * The provided identifier represents a level hierarchy as defined in the
	 * {@link RuntimeLoggerConsts#RUNTIME_LOGGER_CONFIG} XML file. The level
	 * hierarchy is actually the path to the XML element providing the
	 * {@link RuntimeLogger}'s configuration. Each level is separated by the
	 * succeeding level with a dot "." as defined by the
	 * {@link DelimeterConsts#HIERARCHY_DELIMETER} char value. The root logger's
	 * level hierarchy (XML path) is defined by the
	 * {@link RuntimeLoggerConsts#ROOT_LOGGER_ELEMENT_PATH}; at the time of this
	 * writing it was set to "org.refcodes.logger.runtimeLogger". The properties
	 * are currently ignored.
	 */
	@Override
	// ---------------------------------------------------------------------
	// ATTENTION: As the StackTraceElement caller array is evaluated, we 
	// must not delegate this call to one "master" implementation as this 
	// will falsify the actual origin of this factory call.
	// ---------------------------------------------------------------------
	public RuntimeLogger createInstance( String aIdentifier, Properties aProperties ) {
		return new Slf4jRuntimeLoggerImpl( LoggerFactory.getLogger( aIdentifier ) );
	}
}
