// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

/**
 * An {@link ActionMetaDataEvent} is published by an {@link Observable} and is
 * consumed by zero to many {@link Observer} instances. The
 * {@link ActionMetaDataEvent} object describes what the {@link Observable} is
 * publishing in more detail than a plain {@link GenericActionEvent}.
 * <p>
 * An {@link ActionMetaDataEvent} provides Meta-Data describing the
 * {@link GenericActionEvent} in more detail and a source being the origin of
 * the {@link ActionMetaDataEvent}.
 */
public interface ActionMetaDataEvent extends GenericActionMetaDataEvent<Enum<?>, EventMetaData, Object>, MetaDataEvent, ActionEvent {

	/**
	 * Builder for the {@link ActionMetaDataEvent}.
	 */
	public interface ActionMetaDataEventBuilder extends GenericActionMetaDataEventBuilder<Enum<?>, EventMetaData, Object, ActionMetaDataEventBuilder>, ActionMetaDataEvent {

		/**
		 * {@inheritDoc}
		 */
		@Override
		EventMetaDataBuilder getMetaData();
	}
}
