/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.ComponentException;
import org.refcodes.data.Scheme;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.ext.eureka.EurekaRestClientImpl;
import org.refcodes.rest.ext.eureka.EurekaRestServerImpl;
import org.refcodes.rest.ext.eureka.EurekaServer;

public class EurekaRestClientTest {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String FOO_BAR = "foo-bar";

    @Test
    public void testDiscoverServer() throws HttpStatusException, IOException, ComponentException {
        Integer theEurekaPort = PortManagerSingleton.getInstance().bindAnyPort();
        EurekaServer theEurekaServer = new EurekaServer(theEurekaPort);
        LOGGER.info("Starting Eureka on port <" + theEurekaPort + ">: HTTP:\\localhost:" + theEurekaPort);
        Integer theServicePort1 = PortManagerSingleton.getInstance().bindAnyPort();
        Integer theServicePort2 = PortManagerSingleton.getInstance().bindAnyPort();
        UrlImpl theRegistryUrl = new UrlImpl(Scheme.HTTP, "localhost", theEurekaPort.intValue());
        EurekaRestServerImpl theServer1 = new EurekaRestServerImpl();
        theServer1.initialize(FOO_BAR, "INSTANCE_A", Scheme.HTTP, null, null, null, theServicePort1.intValue(), null, (Url)theRegistryUrl);
        EurekaRestServerImpl theServer2 = new EurekaRestServerImpl();
        theServer2.initialize(FOO_BAR, "INSTANCE_B", Scheme.HTTP, null, null, null, theServicePort2.intValue(), null, (Url)theRegistryUrl);
        theServer1.open(theServicePort1.intValue());
        theServer1.start();
        theServer2.open(theServicePort2.intValue());
        theServer2.start();
        EurekaRestClientImpl theEurekaClient = new EurekaRestClientImpl();
        theEurekaClient.initialize(theServer1.getHttpRegistryUrl());
        theEurekaClient.start();
        RestResponse theResponse = theEurekaClient.doGet(Scheme.HTTP, FOO_BAR, "/ping");
        Assertions.assertEquals((Object)HttpStatusCode.OK, (Object)theResponse.getHttpStatusCode());
        theServer1.pause();
        theServer1.resume();
        theServer1.stop();
        theServer1.destroy();
        theServer2.destroy();
        theEurekaClient.destroy();
        theEurekaServer.destroy();
        PortManagerSingleton.getInstance().unbindPort(theServicePort1);
        PortManagerSingleton.getInstance().unbindPort(theServicePort2);
        PortManagerSingleton.getInstance().unbindPort(theEurekaPort);
    }
}

