/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.ComponentException;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.ext.eureka.EurekaRestServerImpl;
import org.refcodes.rest.ext.eureka.EurekaServer;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class EurekaRestServerTest {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testRegisterServer() throws HttpStatusException, IOException, ComponentException {
        Integer theEurekaPort = PortManagerSingleton.getInstance().bindAnyPort();
        EurekaServer theEurekaServer = new EurekaServer(theEurekaPort);
        LOGGER.info("Starting Eureka on port <" + theEurekaPort + ">: HTTP:\\localhost:" + theEurekaPort);
        Integer theServicePort = PortManagerSingleton.getInstance().bindAnyPort();
        UrlImpl theRegistryUrl = new UrlImpl(Scheme.HTTP, "localhost", theEurekaPort.intValue());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        EurekaRestServerImpl theServer = new EurekaRestServerImpl();
        theServer.initialize("foo-bar", null, Scheme.HTTP, null, null, null, theServicePort.intValue(), null, (Url)theRegistryUrl);
        HttpRestClientImpl theClient = new HttpRestClientImpl();
        theClient.setBaseUrl(theServer.getHttpRegistryUrl());
        theClient.open();
        RestResponse theResponse = theClient.doGet(theServer.getAlias() + Delimiter.PATH.getChar() + theServer.getInstanceId());
        System.out.println(new VerboseTextBuilderImpl().withElements(theResponse.toDump()).toString());
        String theBody = gson.toJson(jp.parse(theResponse.getHttpBody()));
        System.out.println(theBody);
        Assertions.assertEquals((Object)HttpStatusCode.OK, (Object)theResponse.getHttpStatusCode());
        theServer.open(theServicePort.intValue());
        theServer.start();
        theResponse = theClient.doGet(theServer.getAlias());
        System.out.println(new VerboseTextBuilderImpl().withElements(theResponse.toDump()).toString());
        theBody = gson.toJson(jp.parse(theResponse.getHttpBody()));
        System.out.println(theBody);
        theResponse = theClient.doGet(theServer.getAlias() + Delimiter.PATH.getChar() + theServer.getInstanceId());
        System.out.println(new VerboseTextBuilderImpl().withElements(theResponse.toDump()).toString());
        theBody = gson.toJson(jp.parse(theResponse.getHttpBody()));
        System.out.println(theBody);
        Assertions.assertEquals((Object)HttpStatusCode.OK, (Object)theResponse.getHttpStatusCode());
        theServer.pause();
        theServer.resume();
        theServer.stop();
        theServer.destroy();
        theEurekaServer.destroy();
        PortManagerSingleton.getInstance().unbindPort(theServicePort);
        PortManagerSingleton.getInstance().unbindPort(theEurekaPort);
    }
}

