/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Scheme;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.net.ApplicationJsonFactory;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.HttpBodyMapImpl;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.ext.eureka.AmazonMetaData;
import org.refcodes.rest.ext.eureka.AmazonMetaDataImpl;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaServerDescriptorImpl;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;

public class EurekaServerDescriptorTest {
    @Test
    public void testEurekaServerDescriptor() throws MarshalException, UnmarshalException {
        ApplicationJsonFactory theFactory = new ApplicationJsonFactory();
        AmazonMetaDataImpl theMetaData = new AmazonMetaDataImpl();
        theMetaData.setAmiId("AmiId");
        theMetaData.setAmiLaunchIndex(Integer.valueOf(0));
        theMetaData.setAmiManifestPath("AmiManifestPath");
        theMetaData.setAvailabilityZone("AvailabilityZone");
        theMetaData.setHostname("Hostname");
        theMetaData.setInstanceId("InstanceId");
        theMetaData.setInstanceType("InstanceType");
        theMetaData.setLocalHostName("LocalHostName");
        theMetaData.setLocalIpv4("LocalIpv4");
        theMetaData.setPublicHostname("PublicHostName");
        theMetaData.setPublicIpv4("PublicIpv4");
        EurekaServerDescriptorImpl theDescriptor = new EurekaServerDescriptorImpl();
        theDescriptor.setAlias("Alias");
        theDescriptor.setAmazonMetaData((AmazonMetaData)theMetaData);
        theDescriptor.setEurekaDataCenterType(EurekaDataCenterType.AMAZON);
        theDescriptor.setEurekaServiceStatus(EurekaServiceStatus.UNKNOWN);
        theDescriptor.setHost("Host");
        theDescriptor.setLeaseEvictionDurationInSecs(Integer.valueOf(120));
        theDescriptor.setPingUrl((Url)new UrlImpl(Scheme.HTTP, "Host", "/ping"));
        theDescriptor.setPort(80);
        theDescriptor.setVirtualHost("VirtualHost");
        String theMarshaled = (String)theFactory.toMarshaled((Object)theDescriptor);
        HttpBodyMap theBodyMap = (HttpBodyMap)theFactory.toUnmarshaled((Object)theMarshaled, HttpBodyMapImpl.class);
        Assertions.assertEquals((int)theDescriptor.size(), (int)theBodyMap.size());
        for (String eKey : theDescriptor.keySet()) {
            Assertions.assertEquals((Object)theDescriptor.get((Object)eKey), (Object)theBodyMap.get((Object)eKey));
        }
    }
}

