// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest.ext.eureka;

import java.util.concurrent.ExecutorService;

import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.HttpRestServerImpl;

/**
 * The {@link EurekaRestServerImpl} enriches the {@link HttpRestServer} with
 * functionality such registering and unregistering from / to a Eureka discovery
 * service.
 * 
 * Follow the documentation of the {@link EurekaRestServer} in order to initiate
 * the states such as {@link EurekaServiceStatus#UP},
 * {@link EurekaServiceStatus#DOWN} or
 * {@link EurekaServiceStatus#OUT_OF_SERVICE} and unregistering.
 */
public class EurekaRestServerImpl extends EurekaRestServerDecorator implements EurekaRestServer {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link EurekaRestServerImpl} with discovery functionality.
	 * Use {@link #initialize()}, {@link #start()}, {@link #pause()},
	 * {@link #resume()}, {@link #stop()} and {@link #destroy()} for publishing
	 * status updates to Eureka. Use
	 * {@link #open(org.refcodes.net.HttpServerContext)} or similar to activate
	 * your server.
	 */
	public EurekaRestServerImpl() {
		super( new HttpRestServerImpl() );
	}

	/**
	 * Constructs a {@link EurekaRestServerImpl} with discovery functionality.
	 * Use {@link #initialize()}, {@link #start()}, {@link #pause()},
	 * {@link #resume()}, {@link #stop()} and {@link #destroy()} for publishing
	 * status updates to Eureka. Use
	 * {@link #open(org.refcodes.net.HttpServerContext)} or similar to activate
	 * your server.
	 *
	 * @param aExecutorService An executor service to be used when creating
	 *        {@link Thread}s.
	 */
	public EurekaRestServerImpl( ExecutorService aExecutorService ) {
		super( new HttpRestServerImpl( aExecutorService ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
