// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.rest.impls;

import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestClientSugar;

/**
 * The singleton of the {@link HttpRestClientImpl} for easy
 * {@link HttpRestClient} access. Used by the {@link HttpRestClientSugar}'s
 * syntactic sugar.
 */
public class HttpRestClientSingleton extends HttpRestClientImpl {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private static HttpRestClientSingleton _loopbackRestServerSingleton;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new http rest client singleton.
	 */
	protected HttpRestClientSingleton() {}

	/**
	 * Returns the singleton's instance as fabricated by this
	 * {@link HttpRestClientSingleton}.
	 *
	 * @return The {@link HttpRestClientImpl} singleton's instance.
	 */
	public static HttpRestClient getInstance() {
		if ( _loopbackRestServerSingleton == null ) {
			synchronized ( HttpRestClientSingleton.class ) {
				_loopbackRestServerSingleton = new HttpRestClientSingleton();
			}
		}
		return _loopbackRestServerSingleton;
	}
}
