// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.rest.impls;

import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.HttpRestServerSugar;

/**
 * The singleton of the {@link HttpRestServerImpl} for easy
 * {@link HttpRestServer} access. Used by the {@link HttpRestServerSugar}'s
 * syntactic sugar.
 */
public class HttpRestServerSingleton extends HttpRestServerImpl {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private static HttpRestServerSingleton _httpRestServerSingleton;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new http rest server singleton.
	 */
	protected HttpRestServerSingleton() {}

	/**
	 * Returns the singleton's instance as fabricated by this
	 * {@link HttpRestServerSingleton}.
	 *
	 * @return The {@link HttpRestServerImpl} singleton's instance.
	 */
	public static HttpRestServer getInstance() {
		if ( _httpRestServerSingleton == null ) {
			synchronized ( HttpRestServerSingleton.class ) {
				_httpRestServerSingleton = new HttpRestServerSingleton();
			}
		}
		return _httpRestServerSingleton;
	}
}
