/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpStatusException;
import org.refcodes.rest.RestEndpointBuilder;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestRequestObserver;

public class RestEndpointBuilderImpl
implements RestEndpointBuilder {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected RestRequestObserver _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPattern = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestEndpointBuilderImpl() {
    }

    public RestEndpointBuilderImpl(HttpMethod aHttpMethod, String aLocatorPattern, RestRequestObserver aRequestObserver) {
        this._httpMethod = aHttpMethod;
        this._locatorPattern = aLocatorPattern;
        this._requestObserver = aRequestObserver;
    }

    @Override
    public void setLocatorPattern(String aLocatorPattern) {
        this._locatorPattern = aLocatorPattern;
    }

    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    @Override
    public void setRequestObserver(RestRequestObserver aLambda) {
        this._requestObserver = aLambda;
    }

    @Override
    public RestRequestObserver getRequestObserver() {
        return this._requestObserver;
    }

    @Override
    public void onRequest(RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            this._requestObserver.onRequest(aRequest, aResponse);
        } else {
            LOGGER.warn("Ignoring request <" + aRequest + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may not have opened it?");
        }
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPattern() {
        return this._locatorPattern;
    }

    public void open() throws OpenException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    public void close() throws CloseException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

