// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import java.util.Iterator;

import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.data.Scheme;
import org.refcodes.net.BasicAuthObserver;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerContext;
import org.refcodes.net.HttpsConnectionRequestObserver;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeFactory;
import org.refcodes.security.KeyStoreDescriptor;

/**
 * Abstract class for easily decorating a {@link HttpRestServer}.
 */
public abstract class AbstractHttpRestServerDecorator<B extends HttpRestServer> implements HttpRestServer {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected HttpRestServer _server;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Decorates the given {@link HttpRestServer} with additional functionality.
	 * 
	 * @param aServer The {@link HttpRestServer} to be decorated.
	 */
	public AbstractHttpRestServerDecorator( HttpRestServer aServer ) {
		_server = aServer;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPort() {
		return _server.getPort();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPort( int aPort ) {
		_server.setPort( aPort );
	}

	@Override
	public Scheme getScheme() {
		return _server.getScheme();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setScheme( Scheme aScheme ) {
		_server.setScheme( aScheme );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean addMediaTypeFactory( MediaTypeFactory aMediaTypeFactory ) {
		return _server.addMediaTypeFactory( aMediaTypeFactory );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws CloseException {
		_server.close();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void closeIn( int aCloseInMillis ) {
		_server.closeIn( aCloseInMillis );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void closeQuietly() {
		_server.closeQuietly();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void closeUnchecked() {
		_server.closeUnchecked();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void disableRequestCorrelation() {
		_server.disableRequestCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void disableSessionCorrelation() {
		_server.disableSessionCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void enableRequestCorrelation() {
		_server.enableRequestCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void enableSessionCorrelation() {
		_server.enableSessionCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getBaseLocator() {
		return _server.getBaseLocator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MediaType[] getFactoryMediaTypes() {
		return _server.getFactoryMediaTypes();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRealm() {
		return _server.getRealm();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasMediaTypeFactory( MediaType aMediaType ) {
		return _server.hasMediaTypeFactory( aMediaType );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasObserverSubscription( RestEndpoint aObserver ) {
		return _server.hasObserverSubscription( aObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasRequestCorrelation() {
		return _server.hasRequestCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasSessionCorrelation() {
		return _server.hasSessionCorrelation();
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B onBasicAuthRequest( BasicAuthObserver aObserver ) {
		_server.onBasicAuthRequest( aObserver );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B onConnectionRequest( HttpsConnectionRequestObserver aObserver ) {
		_server.onConnectionRequest( aObserver );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onDelete( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onDelete( aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onGet( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onGet( aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onPost( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onPost( aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onPut( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onPut( aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onRequest( HttpMethod aHttpMethod, String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onRequest( aHttpMethod, aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean onRequest( RestEndpoint aRestEndpoint ) {
		return _server.onRequest( aRestEndpoint );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestEndpointBuilder onRequest( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return _server.onRequest( aLocatorPattern, aRequestObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void open( int aPort ) throws OpenException {
		_server.open( aPort );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void open( int aPort, int aMaxConnections ) throws OpenException {
		_server.open( aPort, aMaxConnections );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void open( String aProtocol, KeyStoreDescriptor aStoreDescriptor, int aPort ) throws OpenException {
		_server.open( aProtocol, aStoreDescriptor, aPort );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void open( String aProtocol, KeyStoreDescriptor aStoreDescriptor, int aPort, int aMaxConnections ) throws OpenException {
		_server.open( aProtocol, aStoreDescriptor, aPort, aMaxConnections );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void openUnchecked( HttpServerContext aConnection ) {
		_server.openUnchecked( aConnection );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBaseLocator( String aBaseLocator ) {
		_server.setBaseLocator( aBaseLocator );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRealm( String aRealm ) {
		_server.setRealm( aRealm );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRequestCorrelation( boolean hasRequestCorrelation ) {
		_server.setRequestCorrelation( hasRequestCorrelation );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSessionCorrelation( boolean hasSessionCorrelation ) {
		_server.setSessionCorrelation( hasSessionCorrelation );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean subscribeObserver( RestEndpoint aObserver ) {
		boolean isSubscribed = _server.subscribeObserver( aObserver );
		return isSubscribed;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MediaTypeFactory toMediaTypeFactory( MediaType aMediaType ) {
		return _server.toMediaTypeFactory( aMediaType );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean unsubscribeObserver( RestEndpoint aObserver ) {
		return _server.unsubscribeObserver( aObserver );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Iterator<RestEndpoint> observers() {
		return _server.observers();
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withBaseLocator( String aBaseLocator ) {
		_server.setBaseLocator( aBaseLocator );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withClose() throws CloseException {
		_server.close();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withCloseIn( int aCloseInMillis ) {
		_server.closeIn( aCloseInMillis );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withCloseQuietly() {
		_server.closeQuietly();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withCloseUnchecked() {
		_server.closeUnchecked();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withDisableRequestCorrelation() {
		_server.disableRequestCorrelation();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withDisableSessionCorrelation() {
		_server.disableSessionCorrelation();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withEnableRequestCorrelation() {
		_server.enableRequestCorrelation();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withEnableSessionCorrelation() {
		_server.enableSessionCorrelation();
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withOpen( HttpServerContext aConnection ) throws OpenException {
		_server.open( aConnection );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withOpenUnchecked( HttpServerContext aConnection ) {
		_server.openUnchecked( aConnection );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withRealm( String aRealm ) {
		_server.setRealm( aRealm );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withRequestCorrelation( boolean hasRequestCorrelation ) {
		_server.setRequestCorrelation( hasRequestCorrelation );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public B withSessionCorrelation( boolean hasSessionCorrelation ) {
		_server.setSessionCorrelation( hasSessionCorrelation );
		return (B) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getMaxConnections() {
		return _server.getMaxConnections();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public KeyStoreDescriptor getKeyStoreDescriptor() {
		return _server.getKeyStoreDescriptor();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setKeyStoreDescriptor( KeyStoreDescriptor aStoreDescriptor ) {
		_server.setKeyStoreDescriptor( aStoreDescriptor );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMaxConnections( int aMaxConnections ) {
		_server.setMaxConnections( aMaxConnections );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setProtocol( String aProtocol ) {
		_server.setProtocol( aProtocol );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toProtocol() {
		return _server.toProtocol();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
