package org.refcodes.rest;

import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.net.BasicAuthRequest;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.LocalAddressAccessor;
import org.refcodes.net.RealmAccessor;
import org.refcodes.net.RemoteAddressAccessor;
import org.refcodes.observer.GenericActionEvent;

/**
 * Defines a {@link BasicAuthEvent} being the request as consumed by a
 * {@link RestEndpoint}. Usually you will use
 * {@link RestServer#onRequest(HttpMethod, String, RestRequestObserver)} for
 * registering a {@link RestRequestObserver} to the {@link RestServer} (
 * {@link HttpRestServer}).
 */
public interface BasicAuthEvent extends BasicAuthRequest, GenericActionEvent<HttpMethod, RestServer>, WildcardSubstitutes, RealmAccessor, LocalAddressAccessor, RemoteAddressAccessor {

	/**
	 * {@inheritDoc}
	 */
	@Override
	default HttpMethod getAction() {
		return getHttpMethod();
	}
}
