// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

/**
 * Provides an accessor for a home {@link RestRequestObserver} property.
 */
public interface HomeRequestObserverAccessor {

	/**
	 * Retrieves the home {@link RestRequestObserver} from the home
	 * {@link RestRequestObserver} property.
	 * 
	 * @return The home {@link RestRequestObserver} stored by the home
	 *         {@link RestRequestObserver} property.
	 */
	RestRequestObserver getHomeRequestObserver();

	/**
	 * Provides a mutator for a home {@link RestRequestObserver} property.
	 */
	public interface HomeRequestObserverMutator {

		/**
		 * Sets the home {@link RestRequestObserver} for the home
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aHomeRequestObserver The home {@link RestRequestObserver} to
		 *        be stored by the home {@link RestRequestObserver} property.
		 */
		void setHomeRequestObserver( RestRequestObserver aHomeRequestObserver );
	}

	/**
	 * Provides a builder method for a home {@link RestRequestObserver} property
	 * returning the builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface HomeRequestObserverBuilder<B extends HomeRequestObserverBuilder<B>> {

		/**
		 * Sets the home {@link RestRequestObserver} for the home
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aRequestObserver The home {@link RestRequestObserver} to be
		 *        stored by the home {@link RestRequestObserver} property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withHomeRequestObserver( RestRequestObserver aRequestObserver );
	}

	/**
	 * Provides a home {@link RestRequestObserver} property.
	 */
	public interface HomeRequestObserverProperty extends HomeRequestObserverAccessor, HomeRequestObserverMutator {}
}
