package org.refcodes.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;

import org.refcodes.component.OpenException;
import org.refcodes.net.HttpServerContext;
import org.refcodes.net.Url;
import org.refcodes.security.TrustStoreDescriptor;

/**
 * Declarative syntactic sugar which may be statically imported in order to
 * allow declarative definitions of REST client functionality:
 * 
 * <code>import static org.refcodes.rest.HttpRestClientSugar.*; </code>
 */
public class HttpRestClientSugar extends RestDeleteClientSugar {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also {@link HttpRestClient#open()}
	 *
	 * @throws OpenException thrown in case something went wrong.
	 */
	public static void open() throws OpenException {
		HttpRestClientSingleton.getInstance().open();
	}

	/**
	 * See also {@link HttpRestClient#open(Url, TrustStoreDescriptor)}
	 *
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTPS.
	 * 
	 * @throws OpenException thrown in case something went wrong.
	 */
	public static void open( TrustStoreDescriptor aStoreDescriptor ) throws OpenException {
		HttpRestClientSingleton.getInstance().open( aStoreDescriptor );
	}

	/**
	 * See also {@link HttpRestClient#open(Url)}
	 *
	 * @param aBaseUrl The base {@link Url} to be used.
	 * 
	 * @throws OpenException thrown in case something went wrong.
	 */
	public static void open( Url aBaseUrl ) throws OpenException {
		HttpRestClientSingleton.getInstance().open( aBaseUrl );
	}

	/**
	 * See also {@link HttpRestClient#open(Url, TrustStoreDescriptor)}
	 *
	 * @param aBaseUrl The base {@link Url} to be used.
	 * 
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTPS.
	 * 
	 * @throws OpenException thrown in case something went wrong.
	 */
	public static void open( Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor ) throws OpenException {
		HttpRestClientSingleton.getInstance().open( aBaseUrl, aStoreDescriptor );
	}

	/**
	 * See {@link HttpRestServer#open(Object)}
	 *
	 * @param aCtx The context describing the parameters required to open the
	 *        connection.
	 * 
	 * @return The {@link HttpRestServer}
	 * 
	 * @throws OpenException thrown in case something went wrong.
	 */
	public static HttpRestServer open( HttpServerContext aCtx ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aCtx );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See also {@link HttpRestClient#withBaseUrl(String)}
	 *
	 * @param aBaseUrl The base url
	 * 
	 * @return The HTTP rest client
	 * 
	 * @throws MalformedURLException the malformed URL exception
	 */
	public static HttpRestClient withBaseUrl( String aBaseUrl ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().withBaseUrl( aBaseUrl );
	}

	/**
	 * See also {@link HttpRestClient#withBaseUrl(URL)}
	 *
	 * @param aBaseUrl The base url
	 * @return The HTTP rest client
	 */
	public static HttpRestClient withBaseUrl( URL aBaseUrl ) {
		return HttpRestClientSingleton.getInstance().withBaseUrl( aBaseUrl );
	}

	/**
	 * See also {@link HttpRestClient#withUserAgent(String)}
	 *
	 * @param aUserAgent The user agent
	 * @return The HTTP rest client
	 * @throws MalformedURLException the malformed URL exception
	 */
	public static HttpRestClient withUserAgent( String aUserAgent ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().withUserAgent( aUserAgent );
	}

	// /////////////////////////////////////////////////////////////////////////
	// REQUEST BUILDER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL + HOST + PORT + PATH:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL + HOST + PATH:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL (STRING) + HOST + PORT + PATH:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL (STRING) + HOST + PATH:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
