// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import java.io.InputStream;

import org.refcodes.mixin.Dumpable;
import org.refcodes.net.HeaderFields;
import org.refcodes.net.HeaderFieldsAccessor.HeaderFieldsProperty;
import org.refcodes.net.HttpClientRequest;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.RequestHeaderFields;

/**
 * A {@link RestRequest} describes a REST request and the {@link RestResponse}
 * providing the response. The {@link RestRequest} describes the
 * {@link HttpMethod} to be used, the targeted URL, the {@link HeaderFields} as
 * well as the Query-Fields and the request {@link Object} or
 * {@link InputStream}.
 */
public interface RestRequest extends HttpClientRequest, HeaderFieldsProperty<RequestHeaderFields>, Dumpable {}