/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.VetoException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.matcher.PathMatcherImpl;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.net.ApplicationFormFactory;
import org.refcodes.net.ApplicationJsonFactory;
import org.refcodes.net.ApplicationXmlFactory;
import org.refcodes.net.BasicAuthRequiredException;
import org.refcodes.net.ContentType;
import org.refcodes.net.ContentTypeImpl;
import org.refcodes.net.HeaderField;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpRequest;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.InternalServerErrorException;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeFactory;
import org.refcodes.net.NotFoundException;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.TextPlainFactory;
import org.refcodes.net.UnsupportedMediaTypeException;
import org.refcodes.net.Url;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestEventImpl;
import org.refcodes.rest.RestServer;
import org.refcodes.runtime.Correlation;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.VerboseTextBuilderImpl;

public abstract class AbstractRestServer
extends AbstractObservable<RestEndpoint, HttpRequest>
implements RestServer {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private Map<PathMatcherImpl, List<RestEndpoint>> _matcherEndpoints = new LinkedHashMap<PathMatcherImpl, List<RestEndpoint>>();
    private String _realm = SystemUtility.getComputerName();
    private String _baseLocator = null;
    protected boolean _hasRequestCorrelation = true;
    protected boolean _hasSessionCorrelation = true;
    protected HttpExceptionHandling _httpExceptionHandling = HttpExceptionHandling.REPLACE;
    protected HttpExceptionHandler _httpExceptionHandler = null;

    public AbstractRestServer() {
        this.initMedaTypeFactories();
    }

    public AbstractRestServer(ExecutorService aExecutorService) {
        super(aExecutorService);
        this.initMedaTypeFactories();
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationJsonFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationXmlFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new TextPlainFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationFormFactory());
    }

    @Override
    public HttpExceptionHandler getHttpExceptionHandler() {
        return this._httpExceptionHandler;
    }

    @Override
    public void setHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._httpExceptionHandler = aHttpErrorHandler;
    }

    @Override
    public HttpExceptionHandling getHttpExceptionHandling() {
        return this._httpExceptionHandling;
    }

    @Override
    public void setHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._httpExceptionHandling = aHttpErrorHandling;
    }

    public void setObserversActive(boolean isActive) {
        super.setObserversActive(isActive);
    }

    public boolean isObserversActive() {
        return super.isObserversActive();
    }

    public Iterator<RestEndpoint> observers() {
        return super.observers();
    }

    public void setRequestCorrelation(boolean hasRequestCorrelation) {
        this._hasRequestCorrelation = hasRequestCorrelation;
    }

    public boolean hasRequestCorrelation() {
        return this._hasRequestCorrelation;
    }

    public void setSessionCorrelation(boolean hasSessionCorrelation) {
        this._hasSessionCorrelation = hasSessionCorrelation;
    }

    public boolean hasSessionCorrelation() {
        return this._hasSessionCorrelation;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String aRealm) {
        this._realm = aRealm;
    }

    public String getBaseLocator() {
        return this._baseLocator;
    }

    public void setBaseLocator(String aBaseLocator) {
        if (!aBaseLocator.startsWith(Delimiter.PATH.getChar() + "")) {
            throw new IllegalArgumentException("Your provided base locator <" + aBaseLocator + "> is not an absolute locator, it has to start with a slash (\"" + Delimiter.PATH.getChar() + "\") character to be an absolute locator.");
        }
        this._baseLocator = aBaseLocator;
    }

    public synchronized boolean subscribeObserver(RestEndpoint aObserver) {
        if (super.subscribeObserver((Object)aObserver)) {
            PathMatcherImpl theMatcher = new PathMatcherImpl(aObserver.getLocatorPattern());
            List<RestEndpoint> theEndpoints = this._matcherEndpoints.get(theMatcher);
            if (theEndpoints == null) {
                theEndpoints = new ArrayList<RestEndpoint>();
                this._matcherEndpoints.put(theMatcher, theEndpoints);
            }
            theEndpoints.add(aObserver);
            return true;
        }
        return false;
    }

    public synchronized boolean unsubscribeObserver(RestEndpoint aObserver) {
        if (super.unsubscribeObserver((Object)aObserver)) {
            Iterator<PathMatcherImpl> eMatchers = this._matcherEndpoints.keySet().iterator();
            while (eMatchers.hasNext()) {
                List<RestEndpoint> eObservers = this._matcherEndpoints.get(eMatchers.next());
                Iterator<RestEndpoint> eEndpoints = eObservers.iterator();
                while (eEndpoints.hasNext()) {
                    if (aObserver != eEndpoints.next()) continue;
                    eEndpoints.remove();
                }
                if (!eObservers.isEmpty()) continue;
                eMatchers.remove();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addMediaTypeFactory(MediaTypeFactory aMediaTypeFactory) {
        if (this._mediaTypeFacotries.containsKey(aMediaTypeFactory.getMediaType())) {
            return false;
        }
        this._mediaTypeFacotries.put(aMediaTypeFactory.getMediaType(), aMediaTypeFactory);
        return true;
    }

    public MediaTypeFactory toMediaTypeFactory(MediaType aMediaType) {
        return this._mediaTypeFacotries.get(aMediaType);
    }

    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    public void dispose() {
        this._matcherEndpoints.clear();
        super.dispose();
    }

    protected void onHttpRequest(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aRequestHeaderFields, InputStream aHttpInputStream, HttpServerResponse aHttpServerResponse) throws HttpStatusException {
        String theLocator = aUrl.getPath();
        RestEndpoint theEndpoint = null;
        ContentType theMediaType = this.toNegotiatedContenType(aRequestHeaderFields);
        if (theMediaType != null) {
            ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).putContentType((HttpMediaType)theMediaType);
        }
        if (this._baseLocator == null || theLocator.toLowerCase().startsWith(this._baseLocator.toLowerCase())) {
            if (this._baseLocator != null) {
                theLocator = theLocator.substring(this._baseLocator.length());
            }
            Object eResponse = null;
            for (PathMatcherImpl eMatcher : this._matcherEndpoints.keySet()) {
                WildcardSubstitutes eWildcardSubstitutes = eMatcher.toWildcardSubstitutes(theLocator);
                if (eWildcardSubstitutes == null) continue;
                List<RestEndpoint> eEndpoints = this._matcherEndpoints.get(eMatcher);
                for (RestEndpoint eEndpoint : eEndpoints) {
                    if (eEndpoint.getHttpMethod() != null && eEndpoint.getHttpMethod() != aHttpMethod) continue;
                    if (theEndpoint == null) {
                        theEndpoint = eEndpoint;
                    }
                    RestRequestEventImpl eRestRequestEvent = new RestRequestEventImpl(aLocalAddress, aRemoteAddress, aHttpMethod, aUrl, eWildcardSubstitutes, aRequestHeaderFields, aHttpInputStream, this);
                    this.doRequestCorrelation(aRequestHeaderFields, aHttpServerResponse);
                    this.doSessionCorrelation(aRequestHeaderFields, aHttpServerResponse);
                    try {
                        eEndpoint.onRequest(eRestRequestEvent, aHttpServerResponse);
                    }
                    catch (BasicAuthRequiredException e) {
                        ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).putBasicAuthRequired(this.getRealm());
                        throw e;
                    }
                    if (eResponse == null) {
                        eResponse = aHttpServerResponse.getResponse();
                        continue;
                    }
                    if (eResponse == null) continue;
                    LOGGER.warn("An endpoint of type <" + eEndpoint.getClass().getName() + "> (" + eEndpoint + ") would overwrite the response already produced by an endpoint of type <" + theEndpoint.getClass().getName() + "> (" + theEndpoint + " )");
                    throw new InternalServerErrorException("Unambiguous responsibility detected for handling resource locator <" + theLocator + "> with HTTP-Method <" + aHttpMethod + ">.");
                }
            }
        }
        if (theEndpoint == null) {
            throw new NotFoundException("There is none endpoint for handling resource locator <" + theLocator + "> with HTTP-Method <" + aHttpMethod + ">.");
        }
    }

    protected ContentType toNegotiatedContenType(RequestHeaderFields aRequestHeaderFields) {
        ContentType theMediatype = null;
        List theRequestAcceptTypes = aRequestHeaderFields.getAcceptTypes();
        if (theRequestAcceptTypes != null) {
            for (ContentType theContentType : theRequestAcceptTypes) {
                if (!this.hasMediaTypeFactory(theContentType.getMediaType())) continue;
                theMediatype = theContentType;
                break;
            }
        } else {
            List theUnkonwnContentTypes;
            ContentType theRequestContentType;
            List theUnkonwnAcceptTypes;
            if ((theUnkonwnAcceptTypes = aRequestHeaderFields.getUnknownAcceptTypes()) != null && theUnkonwnAcceptTypes.size() != 0) {
                LOGGER.warn("Unable to resolve unknown request's Header-Field <" + HeaderField.ACCEPT.getName() + ">: " + new VerboseTextBuilderImpl().withElements((Collection)theUnkonwnAcceptTypes).toString());
            }
            if ((theRequestContentType = aRequestHeaderFields.getContentType()) != null && this.hasMediaTypeFactory(theRequestContentType.getMediaType())) {
                theMediatype = theRequestContentType;
            }
            if ((theUnkonwnContentTypes = aRequestHeaderFields.getUnknownContentTypes()) != null && theUnkonwnContentTypes.size() != 0) {
                LOGGER.warn("Unable to resolve unknown request's Header-Field <" + HeaderField.CONTENT_TYPE.getName() + ">: " + new VerboseTextBuilderImpl().withElements((Collection)theUnkonwnContentTypes).toString());
            }
        }
        return theMediatype;
    }

    protected byte[] toResponseBody(Object aResponse, RequestHeaderFields aRequestHeaderFields, ResponseHeaderFields aResponseHeaderFields) throws MarshalException, UnsupportedMediaTypeException {
        if (aResponse == null) {
            return new byte[0];
        }
        String theResponseBody = this.toMarshaled(aResponse, aResponseHeaderFields.getContentType(), aResponseHeaderFields);
        if (theResponseBody != null) {
            LOGGER.info("Auto-determined Response-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + aResponseHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            return theResponseBody.getBytes();
        }
        List theAcceptTypes = aRequestHeaderFields.getAcceptTypes();
        if (theAcceptTypes != null) {
            for (ContentType eContentType : theAcceptTypes) {
                theResponseBody = this.toMarshaled(aResponse, eContentType, aResponseHeaderFields);
                if (theResponseBody == null) continue;
                LOGGER.info("Auto-determined Request-Header's <" + HeaderField.ACCEPT.getName() + "> Media-Type <" + eContentType.toHttpMediaType() + "> for the response.");
                return theResponseBody.getBytes();
            }
        }
        if ((theResponseBody = this.toMarshaled(aResponse, aRequestHeaderFields.getContentType(), aResponseHeaderFields)) != null) {
            LOGGER.info("Auto-determined Request-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + aRequestHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            return theResponseBody.getBytes();
        }
        if (aResponseHeaderFields.getContentType() != null || aRequestHeaderFields.getContentType() != null || aRequestHeaderFields.getAcceptTypes() != null && aRequestHeaderFields.getAcceptTypes().size() != 0) {
            throw new UnsupportedMediaTypeException("No Media-Type factory found for request ACCEPT types <" + new VerboseTextBuilderImpl().withElements((Collection)aRequestHeaderFields.getAcceptTypes()) + "> or response CONTENT-TYPE <" + aResponseHeaderFields.getContentType() + "> or request CONTENT type <" + aRequestHeaderFields.getContentType() + ">.");
        }
        throw new UnsupportedMediaTypeException("No Media-Type in HTTP-Request detected.");
    }

    protected boolean fireEvent(HttpRequest aEvent, RestEndpoint aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
        throw new UnsupportedOperationException("As the #onHttpRequest method takes care of observer invocation.");
    }

    protected void doRequestCorrelation(RequestHeaderFields aRequestHeaderFields, HttpServerResponse aServerResponse) {
        if (this._hasRequestCorrelation) {
            String theRequestId = aRequestHeaderFields.getRequestId() != null ? aRequestHeaderFields.getRequestId() : Correlation.REQUEST.nextId();
            ((ResponseHeaderFields)aServerResponse.getHeaderFields()).putRequestId(theRequestId);
        }
    }

    protected void doSessionCorrelation(RequestHeaderFields aRequestHeaderFields, HttpServerResponse aServerResponse) {
        if (this._hasSessionCorrelation) {
            String theSessionId = aRequestHeaderFields.getSessionId() != null ? aRequestHeaderFields.getSessionId() : Correlation.SESSION.nextId();
            ((ResponseHeaderFields)aServerResponse.getHeaderFields()).putSessionId(theSessionId);
        }
    }

    private String toMarshaled(Object aResponse, MediaType aMediaType, Map<String, String> aMediaTypeParams, ResponseHeaderFields aResponseHeaderFields) {
        MediaTypeFactory theFactory;
        if (aMediaTypeParams != null && aMediaTypeParams.isEmpty()) {
            aMediaTypeParams = null;
        }
        if ((theFactory = this.toMediaTypeFactory(aMediaType)) != null) {
            try {
                String theMarshaled = (String)theFactory.toMarshaled(aResponse, aMediaTypeParams);
                ContentTypeImpl theContentType = new ContentTypeImpl(aMediaType, aMediaTypeParams);
                aResponseHeaderFields.putContentType((HttpMediaType)theContentType);
                return theMarshaled;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String toMarshaled(Object aResponse, ContentType contentType, ResponseHeaderFields aResponseHeaderFields) {
        return this.toMarshaled(aResponse, contentType != null ? contentType.getMediaType() : null, (Map<String, String>)contentType, aResponseHeaderFields);
    }
}

