/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.net.InetSocketAddress;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.BasicAuthCredentials;
import org.refcodes.net.BasicAuthObserver;
import org.refcodes.net.BasicAuthResponse;
import org.refcodes.net.HttpMethod;
import org.refcodes.rest.BasicAuthEndpointBuilder;

public class BasicAuthEndpointBuilderImpl
implements BasicAuthEndpointBuilder {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected BasicAuthObserver _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPattern = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public BasicAuthEndpointBuilderImpl() {
    }

    public BasicAuthEndpointBuilderImpl(HttpMethod aHttpMethod, String aLocatorPattern, BasicAuthObserver aRequestObserver) {
        this._httpMethod = aHttpMethod;
        this._locatorPattern = aLocatorPattern;
        this._requestObserver = aRequestObserver;
    }

    @Override
    public void setLocatorPattern(String aLocatorPattern) {
        this._locatorPattern = aLocatorPattern;
    }

    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    @Override
    public void setRequestObserver(BasicAuthObserver aLambda) {
        this._requestObserver = aLambda;
    }

    @Override
    public BasicAuthObserver getRequestObserver() {
        return this._requestObserver;
    }

    public BasicAuthResponse onBasicAuthRequest(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, String aLocator, BasicAuthCredentials aCredentials, String aRealm) {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            return this._requestObserver.onBasicAuthRequest(aLocalAddress, aRemoteAddress, aHttpMethod, aLocator, aCredentials, aRealm);
        }
        LOGGER.warn("Ignoring Basic-Auth <" + aHttpMethod + "> request for locator <" + aLocator + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may not have opened it?");
        return BasicAuthResponse.BASIC_AUTH_SKIP;
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPattern() {
        return this._locatorPattern;
    }

    public void open() throws OpenException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    public void close() throws CloseException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

