/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.OpenException;
import org.refcodes.net.BaseUrlAccessor;
import org.refcodes.net.HttpClientContext;
import org.refcodes.net.Url;
import org.refcodes.rest.RestClient;
import org.refcodes.security.StoreType;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;

public interface HttpRestClient
extends ConnectionStatusAccessor,
ConnectionComponent<HttpClientContext>,
RestClient,
LinkComponent,
BaseUrlAccessor.BaseUrlProperty,
BaseUrlAccessor.BaseUrlBuilder<HttpRestClient>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<HttpRestClient> {
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_KEYSTORE_TYPE = StoreType.JKS.name();

    default public void open() throws OpenException {
        this.open(this.getBaseUrl(), this.getTrustStoreDescriptor());
    }

    default public void open(HttpClientContext aCtx) throws OpenException {
        this.open(aCtx.getBaseUrl(), aCtx.getTrustStoreDescriptor());
    }

    default public void open(Url aBaseUrl) throws OpenException {
        this.open(aBaseUrl, this.getTrustStoreDescriptor());
    }

    default public void open(TrustStoreDescriptor aStoreDescriptor) throws OpenException {
        this.open(this.getBaseUrl(), aStoreDescriptor);
    }

    public void open(Url var1, TrustStoreDescriptor var2) throws OpenException;

    @Override
    default public HttpRestClient withDisableRequestCorrelation() {
        this.disableRequestCorrelation();
        return this;
    }

    @Override
    default public HttpRestClient withDisableSessionCorrelation() {
        this.disableSessionCorrelation();
        return this;
    }

    @Override
    default public HttpRestClient withEnableRequestCorrelation() {
        this.enableRequestCorrelation();
        return this;
    }

    @Override
    default public HttpRestClient withEnableSessionCorrelation() {
        this.enableSessionCorrelation();
        return this;
    }

    @Override
    default public HttpRestClient withRequestCorrelation(boolean hasRequestCorrelation) {
        this.setRequestCorrelation(hasRequestCorrelation);
        return this;
    }

    @Override
    default public HttpRestClient withSessionCorrelation(boolean hasSessionCorrelation) {
        this.setSessionCorrelation(hasSessionCorrelation);
        return this;
    }

    default public HttpRestClient withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this.setTrustStoreDescriptor(aStoreDescriptor);
        return this;
    }

    @Override
    default public HttpRestClient withUserAgent(String aUserAgent) {
        this.setUserAgent(aUserAgent);
        return this;
    }
}

