/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.OpenException;
import org.refcodes.data.Scheme;
import org.refcodes.io.MaxConnectionsAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.BasicAuthObservable;
import org.refcodes.net.HttpServerContext;
import org.refcodes.net.HttpsConnectionRequestObservable;
import org.refcodes.net.SchemeAccessor;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.RestServer;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.security.KeyStoreDescriptorAccessor;

public interface HttpRestServer
extends RestServer,
LinkComponent,
ConnectionStatusAccessor,
ConnectionComponent.ConnectionComponentBuilder<HttpServerContext, HttpRestServer>,
BasicAuthObservable<HttpRestServer>,
HttpsConnectionRequestObservable<HttpRestServer>,
PortAccessor.PortProperty,
PortAccessor.PortBuilder<HttpRestServer>,
SchemeAccessor.SchemeProperty,
SchemeAccessor.SchemeBuilder<HttpRestServer>,
KeyStoreDescriptorAccessor.KeyStoreDescriptorProperty,
KeyStoreDescriptorAccessor.KeyStoreDescriptorBuilder<HttpRestServer>,
MaxConnectionsAccessor.MaxConnectionsProperty,
MaxConnectionsAccessor.MaxConnectionsBuilder<HttpRestServer> {
    @Override
    default public HttpRestServer withHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this.setHttpExceptionHandler(aHttpErrorHandler);
        return this;
    }

    @Override
    default public HttpRestServer withHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this.setHttpExceptionHandling(aHttpErrorHandling);
        return this;
    }

    @Override
    default public HttpRestServer withSessionCorrelation(boolean hasSessionCorrelation) {
        this.setSessionCorrelation(hasSessionCorrelation);
        return this;
    }

    @Override
    default public HttpRestServer withEnableSessionCorrelation() {
        this.enableSessionCorrelation();
        return this;
    }

    @Override
    default public HttpRestServer withDisableSessionCorrelation() {
        this.disableSessionCorrelation();
        return this;
    }

    @Override
    default public HttpRestServer withRequestCorrelation(boolean hasRequestCorrelation) {
        this.setRequestCorrelation(hasRequestCorrelation);
        return this;
    }

    @Override
    default public HttpRestServer withEnableRequestCorrelation() {
        this.enableRequestCorrelation();
        return this;
    }

    @Override
    default public HttpRestServer withDisableRequestCorrelation() {
        this.disableRequestCorrelation();
        return this;
    }

    @Override
    default public HttpRestServer withRealm(String aRealm) {
        this.setRealm(aRealm);
        return this;
    }

    @Override
    default public HttpRestServer withBaseLocator(String aBaseLocator) {
        this.setBaseLocator(aBaseLocator);
        return this;
    }

    default public HttpRestServer withClose() throws CloseException {
        this.close();
        return this;
    }

    default public HttpRestServer withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    default public HttpRestServer withCloseIn(int aCloseInMillis) {
        this.closeIn(aCloseInMillis);
        return this;
    }

    default public HttpRestServer withOpen(HttpServerContext aConnection) throws OpenException {
        this.open(aConnection);
        return this;
    }

    default public HttpRestServer withOpen(int aPort) throws OpenException {
        this.open(aPort);
        return this;
    }

    default public HttpRestServer withPort(int aPort) {
        this.setPort(aPort);
        return this;
    }

    default public HttpRestServer withScheme(Scheme aScheme) {
        this.setScheme(aScheme);
        return this;
    }

    default public HttpRestServer withProtocol(String aProtocol) {
        this.setProtocol(aProtocol);
        return this;
    }

    default public HttpRestServer withKeyStoreDescriptor(KeyStoreDescriptor aStoreDescriptor) {
        this.setKeyStoreDescriptor(aStoreDescriptor);
        return this;
    }

    default public HttpRestServer withMaxConnections(int aMaxConnections) {
        this.setMaxConnections(aMaxConnections);
        return this;
    }

    default public void open() throws OpenException {
        this.open(this.toProtocol(), this.getKeyStoreDescriptor(), this.getPort(), this.getMaxConnections());
    }

    default public void open(int aPort) throws OpenException {
        this.open(this.toProtocol(), this.getKeyStoreDescriptor(), aPort, this.getMaxConnections());
    }

    default public void open(int aPort, int aMaxConnections) throws OpenException {
        this.open(this.toProtocol(), this.getKeyStoreDescriptor(), aPort, aMaxConnections);
    }

    default public void open(String aProtocol, KeyStoreDescriptor aStoreDescriptor, int aPort) throws OpenException {
        this.open(aProtocol, aStoreDescriptor, aPort, this.getMaxConnections());
    }

    default public void open(String aProtocol, KeyStoreDescriptor aStoreDescriptor) throws OpenException {
        this.open(aProtocol, aStoreDescriptor, this.getPort(), this.getMaxConnections());
    }

    default public void open(KeyStoreDescriptor aStoreDescriptor, int aPort, int aMaxConnections) throws OpenException {
        this.open(this.toProtocol(), aStoreDescriptor, aPort, aMaxConnections);
    }

    default public void open(KeyStoreDescriptor aStoreDescriptor, int aPort) throws OpenException {
        this.open(this.toProtocol(), aStoreDescriptor, aPort, this.getMaxConnections());
    }

    default public void open(KeyStoreDescriptor aStoreDescriptor) throws OpenException {
        this.open(this.toProtocol(), aStoreDescriptor, this.getPort(), this.getMaxConnections());
    }

    default public void open(Scheme aScheme, KeyStoreDescriptor aStoreDescriptor, int aPort, int aMaxConnections) throws OpenException {
        this.open(aScheme.name(), aStoreDescriptor, aPort, aMaxConnections);
    }

    default public void open(Scheme aScheme, KeyStoreDescriptor aStoreDescriptor, int aPort) throws OpenException {
        this.open(aScheme.toProtocol(), aStoreDescriptor, aPort, this.getMaxConnections());
    }

    default public void open(Scheme aScheme, KeyStoreDescriptor aStoreDescriptor) throws OpenException {
        this.open(aScheme.toProtocol(), aStoreDescriptor, this.getPort(), this.getMaxConnections());
    }

    public void open(String var1, KeyStoreDescriptor var2, int var3, int var4) throws OpenException;

    default public void open(HttpServerContext aConnection) throws OpenException {
        this.open(aConnection.toProtocol(), aConnection.getKeyStoreDescriptor(), aConnection.getPort(), aConnection.getMaxConnections());
    }
}

