/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerRequestImpl;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.Url;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestServer;

public class RestRequestEventImpl
extends HttpServerRequestImpl
implements RestRequestEvent {
    private InetSocketAddress _remoteAddress;
    private InetSocketAddress _localAddress;
    private WildcardSubstitutes _wildcardSubstitutes;
    private String _realm;

    public RestRequestEventImpl(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, WildcardSubstitutes aWildcardSubstitutes, RequestHeaderFields aHeaderFields, InputStream aHttpInputStream, RestServer aRestServer) {
        super(aHttpMethod, aUrl, aHeaderFields, aHttpInputStream, (MediaTypeFactoryLookup)aRestServer);
        this._wildcardSubstitutes = aWildcardSubstitutes;
        this._remoteAddress = aRemoteAddress;
        this._localAddress = aLocalAddress;
        this._realm = aRestServer.getRealm();
    }

    public RestServer getSource() {
        return (RestServer)this._mediaTypeFactoryLookup;
    }

    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    public String getWildcardReplacementAt(int aIndex) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(aIndex);
    }

    public String getWildcardReplacement(String aWildcardName) {
        return this._wildcardSubstitutes.getWildcardReplacement(aWildcardName);
    }

    public String[] getWildcardReplacements(String ... aWildcardNames) {
        return this._wildcardSubstitutes.getWildcardReplacements(aWildcardNames);
    }

    public String[] getWildcardReplacementsAt(int ... aIndexes) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(aIndexes);
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public String getRealm() {
        return this._realm;
    }
}

