/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.SystemContext;

public class SystemContextTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testSystemId1() {
        for (SystemContext eCtx : SystemContext.values()) {
            int theSystemId1 = eCtx.toContextId();
            int theSystemId2 = eCtx.toContextId();
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + theSystemId1);
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + theSystemId2);
            }
            Assertions.assertEquals((int)theSystemId1, (int)theSystemId2);
        }
    }

    @Test
    public void testSystemId2() {
        for (SystemContext eCtx : SystemContext.values()) {
            int theSystemId1 = eCtx.toContextId();
            int theSystemId2 = eCtx.toContextId("REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + theSystemId1);
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + theSystemId2);
            }
            Assertions.assertNotEquals((Object)theSystemId1, (Object)theSystemId2);
        }
    }

    @Test
    public void testSystemId3() {
        for (SystemContext eCtx : SystemContext.values()) {
            int theSystemId1 = eCtx.toContextId("FUNCODES.CLUB");
            int theSystemId2 = eCtx.toContextId("REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + theSystemId1);
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + theSystemId2);
            }
            Assertions.assertNotEquals((Object)theSystemId1, (Object)theSystemId2);
        }
    }

    @Test
    public void testSystemId4() {
        for (SystemContext eCtx : SystemContext.values()) {
            int theSystemId1 = eCtx.toContextId("REFCODES.ORG");
            int theSystemId2 = eCtx.toContextId("REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + theSystemId1);
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + theSystemId2);
            }
            Assertions.assertEquals((int)theSystemId1, (int)theSystemId2);
        }
    }

    @Test
    public void testSystemId5() {
        for (SystemContext eCtx : SystemContext.values()) {
            int theSystemId1 = eCtx.toContextId("FUNCODES.CLUB");
            int theSystemId2 = eCtx.toContextId("FUNCODES.CLUB");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + theSystemId1);
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + theSystemId2);
            }
            Assertions.assertEquals((int)theSystemId1, (int)theSystemId2);
        }
    }

    @Test
    public void testSystemIds1() {
        for (SystemContext eCtx : SystemContext.values()) {
            int[] theSystemIds1 = eCtx.toContextIds(3);
            int[] theSystemIds2 = eCtx.toContextIds(3);
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + Arrays.toString(theSystemIds1));
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + Arrays.toString(theSystemIds2));
            }
            Assertions.assertArrayEquals((int[])theSystemIds1, (int[])theSystemIds2);
        }
    }

    @Test
    public void testSystemIds2() {
        for (SystemContext eCtx : SystemContext.values()) {
            int[] theSystemIds1 = eCtx.toContextIds(3);
            int[] theSystemIds2 = eCtx.toContextIds(3, "REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + Arrays.toString(theSystemIds1));
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + Arrays.toString(theSystemIds2));
            }
            Assertions.assertNotEquals((Object)theSystemIds1, (Object)theSystemIds2);
        }
    }

    @Test
    public void testSystemIds3() {
        for (SystemContext eCtx : SystemContext.values()) {
            int[] theSystemIds1 = eCtx.toContextIds(3, "FUNCODES.CLUB");
            int[] theSystemIds2 = eCtx.toContextIds(3, "REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + Arrays.toString(theSystemIds1));
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + Arrays.toString(theSystemIds2));
            }
            Assertions.assertNotEquals((Object)theSystemIds1, (Object)theSystemIds2);
        }
    }

    @Test
    public void testSystemIds4() {
        for (SystemContext eCtx : SystemContext.values()) {
            int[] theSystemIds1 = eCtx.toContextIds(3, "REFCODES.ORG");
            int[] theSystemIds2 = eCtx.toContextIds(3, "REFCODES.ORG");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + Arrays.toString(theSystemIds1));
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + Arrays.toString(theSystemIds2));
            }
            Assertions.assertArrayEquals((int[])theSystemIds1, (int[])theSystemIds2);
        }
    }

    @Test
    public void testSystemIds5() {
        for (SystemContext eCtx : SystemContext.values()) {
            int[] theSystemIds1 = eCtx.toContextIds(3, "FUNCODES.CLUB");
            int[] theSystemIds2 = eCtx.toContextIds(3, "FUNCODES.CLUB");
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 1 = " + Arrays.toString(theSystemIds1));
            }
            if (IS_LOG_TESTS) {
                System.out.println(eCtx + ": System-ID 2 = " + Arrays.toString(theSystemIds2));
            }
            Assertions.assertArrayEquals((int[])theSystemIds1, (int[])theSystemIds2);
        }
    }

    @Test
    public void testRun() {
        String eId;
        HashSet<String> theIds = new HashSet<String>();
        for (SystemContext eGranularity : SystemContext.values()) {
            eId = "" + eGranularity.toContextId();
            theIds.add(eId);
            if (!IS_LOG_TESTS) continue;
            System.out.println(eGranularity.name() + ": " + eId);
        }
        Assertions.assertEquals((int)SystemContext.values().length, (int)theIds.size());
        for (SystemContext eGranularity : SystemContext.values()) {
            eId = "" + eGranularity.toContextId("_someSeed!");
            theIds.add(eId);
            if (!IS_LOG_TESTS) continue;
            System.out.println(eGranularity.name() + " (+seed): " + eId);
        }
        Assertions.assertEquals((int)(SystemContext.values().length * 2), (int)theIds.size());
    }
}

