/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.jasypt.util.text.BasicTextEncryptor;
import org.refcodes.data.License;
import org.refcodes.data.Prefix;
import org.refcodes.mixin.Loggable;

public final class SecurityUtility
implements Loggable {
    public static final int CIPHER_UID_TIMESTAMP_LENGTH = 14;
    public static final int CIPHER_UID_LENGTH = 24;
    public static final int CIPHER_LENGTH = 48;
    public static final int MESSAGE_LENGTH = 256;
    private static BasicTextEncryptor TEXT_ENCRYPTOR;

    private SecurityUtility() {
    }

    public static String toDecryptedText(String aText) {
        if (aText.toLowerCase().startsWith(Prefix.ENCRYPTED.getPrefix())) {
            String theText = aText.substring(Prefix.ENCRYPTED.getPrefix().length());
            return TEXT_ENCRYPTOR.decrypt(theText);
        }
        String theHint = "";
        if (aText.length() > 12) {
            theHint = "and starting with first three characters \"" + aText.substring(0, 3) + "...\" ";
        }
        new SecurityUtility().warn("A text with length <" + aText.length() + "> " + theHint + "has been provided which is not encrypted. An encrypted text must start with \"" + Prefix.ENCRYPTED.getPrefix() + "\"!");
        return aText;
    }

    public static String toDecryptedText(String aText, String aPassPharse) {
        if (aText.toLowerCase().startsWith(Prefix.ENCRYPTED.getPrefix())) {
            BasicTextEncryptor theTextEncryptor = new BasicTextEncryptor();
            theTextEncryptor.setPassword(aPassPharse);
            String theText = aText.substring(Prefix.ENCRYPTED.getPrefix().length());
            return theTextEncryptor.decrypt(theText);
        }
        String theHint = "";
        if (aText.length() > 12) {
            theHint = "and starting with first three characters \"" + aText.substring(0, 3) + "...\" ";
        }
        new SecurityUtility().warn("A text with length <" + aText.length() + "> " + theHint + "has been provided which is not encrypted. An encrypted text must start with \"" + Prefix.ENCRYPTED.getPrefix() + "\"!");
        return aText;
    }

    public static String toEncryptedText(String aText) {
        return Prefix.ENCRYPTED.getPrefix() + TEXT_ENCRYPTOR.encrypt(aText);
    }

    public static String toEncryptedText(String aText, String aPassPhrase) {
        BasicTextEncryptor theTextEncryptor = new BasicTextEncryptor();
        theTextEncryptor.setPassword(aPassPhrase);
        return Prefix.ENCRYPTED.getPrefix() + theTextEncryptor.encrypt(aText);
    }

    static {
        String thePassPhrase = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface eNetworkInterface = e.nextElement();
                try {
                    byte[] eHardwareAddress = eNetworkInterface.getHardwareAddress();
                    if (eHardwareAddress == null) continue;
                    thePassPhrase = "";
                    for (int i = 0; i < eHardwareAddress.length; ++i) {
                        thePassPhrase = thePassPhrase + (eHardwareAddress[i] < 0 ? "" + (eHardwareAddress[i] & 0xFF) : "" + eHardwareAddress[i]);
                        if (i >= eHardwareAddress.length - 1) continue;
                        thePassPhrase = thePassPhrase + ".";
                    }
                    break;
                }
                catch (SocketException se) {
                    new SecurityUtility().warn("Unable to acquire network interfaces's (\"" + eNetworkInterface.getDisplayName() + "\") hardware address, trying next network interface.", se);
                }
            }
        }
        catch (SocketException se) {
            new SecurityUtility().warn("Unable to acquire machine's network interfaces (using alternate cipher).", se);
        }
        if (thePassPhrase == null) {
            thePassPhrase = License.REFCODES_LICENSE.getText();
        }
        TEXT_ENCRYPTOR = new BasicTextEncryptor();
        TEXT_ENCRYPTOR.setPassword(thePassPhrase);
    }
}

