// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

import java.util.LinkedHashSet;

/**
 * A list of {@link Column} instances, for example describing the elements of a
 * CSV file (visually speaking the of the CSV file's header line), is
 * represented by the {@link org.refcodes.tabular.Header}. The
 * {@link org.refcodes.tabular.Header} preserves an order for a list of
 * {@link org.refcodes.tabular.Column} instances. A
 * {@link org.refcodes.tabular.Header} provides the semantics for related
 * {@link org.refcodes.tabular.Row} instances.
 * <p>
 * The {@link #keySet()} method must provide a predictable order as ensured by
 * the {@link LinkedHashSet} class as of the ordered nature of the
 * {@link Header}.
 *
 * @param <T> The type managed by the {@link Header}.
 */
public interface Header<T> extends HeaderTemplate<T, Column<? extends T>> {}
