// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

import org.refcodes.tabular.TabularException.TabularKeyException;

/**
 * Thrown in case there is a mismatch between the given
 * {@link HeaderMismatchException} and the {@link Row}, i.e. the index for the
 * given key in the header may be out of index of the given row or the given key
 * does not exist in the {@link Header}.
 */
public class HeaderMismatchException extends TabularKeyException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public HeaderMismatchException( String aKey, String aMessage, String aErrorCode ) {
		super( aKey, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public HeaderMismatchException( String aKey, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aKey, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param message the message
	 * @param cause the cause
	 */
	public HeaderMismatchException( String aKey, String message, Throwable cause ) {
		super( aKey, message, cause );
	}

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param message the message
	 */
	public HeaderMismatchException( String aKey, String message ) {
		super( aKey, message );
	}

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public HeaderMismatchException( String aKey, Throwable aCause, String aErrorCode ) {
		super( aKey, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new header mismatch exception.
	 *
	 * @param aKey the key
	 * @param cause the cause
	 */
	public HeaderMismatchException( String aKey, Throwable cause ) {
		super( aKey, cause );
	}
}
