// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

import org.refcodes.exception.AbstractException;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.ValueAccessor;

/**
 * Base exception for the refcodes-tabular artifact.
 */
public abstract class TabularException extends AbstractException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public TabularException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public TabularException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public TabularException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param message the message
	 */
	public TabularException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public TabularException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new tabular exception.
	 *
	 * @param cause the cause
	 */
	public TabularException( Throwable cause ) {
		super( cause );
	}

	/**
	 * Base refcodes-tabular exception with a {@link Column}.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class TabularColumnException extends TabularException implements ColumnAccessor {

		private static final long serialVersionUID = 1L;

		private Column<?> _column;

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public TabularColumnException( Column<?> aColumn, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_column = aColumn;
		}

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularColumnException( Column<?> aColumn, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_column = aColumn;
		}

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param message the message
		 * @param cause the cause
		 */
		public TabularColumnException( Column<?> aColumn, String message, Throwable cause ) {
			super( message, cause );
			_column = aColumn;
		}

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param message the message
		 */
		public TabularColumnException( Column<?> aColumn, String message ) {
			super( message );
			_column = aColumn;
		}

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularColumnException( Column<?> aColumn, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_column = aColumn;
		}

		/**
		 * Instantiates a new tabular column exception.
		 *
		 * @param aColumn the column
		 * @param cause the cause
		 */
		public TabularColumnException( Column<?> aColumn, Throwable cause ) {
			super( cause );
			_column = aColumn;
		}

		/**
		 * Gets the column.
		 *
		 * @return the column
		 */
		@Override
		public Column<?> getColumn() {
			return _column;
		}

		/**
		 * Base refcodes-tabular exception with a {@link Column} and a related
		 * value.
		 */
		static abstract class TabularColumnValueException extends TabularColumnException implements ValueAccessor<Object> {

			private static final long serialVersionUID = 1L;

			private Object _value;

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, String aMessage, String aErrorCode ) {
				super( aColumn, aMessage, aErrorCode );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, String aMessage, Throwable aCause, String aErrorCode ) {
				super( aColumn, aMessage, aCause, aErrorCode );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, String message, Throwable cause ) {
				super( aColumn, message, cause );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, String message ) {
				super( aColumn, message );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, Throwable aCause, String aErrorCode ) {
				super( aColumn, aCause, aErrorCode );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			public TabularColumnValueException( Column<?> aColumn, Object aValue, Throwable cause ) {
				super( aColumn, cause );
				_value = aValue;
			}

			/**
			 * {@inheritDoc}
			 */
			@Override
			public Object getValue() {
				return _value;
			}
		}
	}

	/**
	 * Base refcodes-tabular exception with a {@link Header}.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class TabularHeaderException extends TabularException implements HeaderAccessor {

		private static final long serialVersionUID = 1L;

		private Header _header;

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public TabularHeaderException( Header aHeader, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_header = aHeader;
		}

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularHeaderException( Header aHeader, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_header = aHeader;
		}

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param message the message
		 * @param cause the cause
		 */
		public TabularHeaderException( Header aHeader, String message, Throwable cause ) {
			super( message, cause );
			_header = aHeader;
		}

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param message the message
		 */
		public TabularHeaderException( Header aHeader, String message ) {
			super( message );
			_header = aHeader;
		}

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularHeaderException( Header aHeader, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_header = aHeader;
		}

		/**
		 * Instantiates a new tabular header exception.
		 *
		 * @param aHeader the header
		 * @param cause the cause
		 */
		public TabularHeaderException( Header aHeader, Throwable cause ) {
			super( cause );
			_header = aHeader;
		}

		/**
		 * Gets the header.
		 *
		 * @return the header
		 */
		@Override
		public Header getHeader() {
			return _header;
		}
	}

	/**
	 * Base refcodes-tabular exception with a key (name).
	 */
	static abstract class TabularKeyException extends TabularException implements KeyAccessor<String> {

		private static final long serialVersionUID = 1L;

		private String _key;

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public TabularKeyException( String aKey, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_key = aKey;
		}

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularKeyException( String aKey, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_key = aKey;
		}

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param message the message
		 * @param cause the cause
		 */
		public TabularKeyException( String aKey, String message, Throwable cause ) {
			super( message, cause );
			_key = aKey;
		}

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param message the message
		 */
		public TabularKeyException( String aKey, String message ) {
			super( message );
			_key = aKey;
		}

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public TabularKeyException( String aKey, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_key = aKey;
		}

		/**
		 * Instantiates a new tabular key exception.
		 *
		 * @param aKey the key
		 * @param cause the cause
		 */
		public TabularKeyException( String aKey, Throwable cause ) {
			super( cause );
			_key = aKey;
		}

		/**
		 * Gets the key.
		 *
		 * @return the key
		 */
		@Override
		public String getKey() {
			return _key;
		}
	}
}
