/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.generator.Generator;
import org.robolectric.annotation.processing.generator.JavadocJsonGenerator;
import org.robolectric.annotation.processing.generator.ServiceLoaderGenerator;
import org.robolectric.annotation.processing.generator.ShadowProviderGenerator;
import org.robolectric.annotation.processing.validator.ImplementationValidator;
import org.robolectric.annotation.processing.validator.ImplementsValidator;
import org.robolectric.annotation.processing.validator.RealObjectValidator;
import org.robolectric.annotation.processing.validator.ResetterValidator;
import org.robolectric.annotation.processing.validator.Validator;

@SupportedOptions(value={"org.robolectric.annotation.processing.shadowPackage", "org.robolectric.annotation.processing.shouldInstrumentPackage"})
@SupportedAnnotationTypes(value={"org.robolectric.annotation.*"})
public class RobolectricProcessor
extends AbstractProcessor {
    static final String PACKAGE_OPT = "org.robolectric.annotation.processing.shadowPackage";
    static final String SHOULD_INSTRUMENT_PKG_OPT = "org.robolectric.annotation.processing.shouldInstrumentPackage";
    private RobolectricModel model;
    private String shadowPackage;
    private boolean shouldInstrumentPackages;
    private Map<String, String> options;
    private boolean generated = false;
    private final List<Generator> generators = new ArrayList<Generator>();
    private final Map<TypeElement, Validator> elementValidators = new HashMap<TypeElement, Validator>(13);

    public RobolectricProcessor() {
    }

    @VisibleForTesting
    public RobolectricProcessor(Map<String, String> options) {
        this.processOptions(options);
    }

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        this.processOptions(environment.getOptions());
        this.model = new RobolectricModel(environment.getElementUtils(), environment.getTypeUtils());
        this.addValidator(new ImplementationValidator(this.model, environment));
        this.addValidator(new ImplementsValidator(this.model, environment));
        this.addValidator(new RealObjectValidator(this.model, environment));
        this.addValidator(new ResetterValidator(this.model, environment));
        this.generators.add(new ShadowProviderGenerator(this.model, environment, this.shadowPackage, this.shouldInstrumentPackages));
        this.generators.add(new ServiceLoaderGenerator(environment, this.shadowPackage));
        this.generators.add(new JavadocJsonGenerator(this.model, environment));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Validator validator = this.elementValidators.get(typeElement);
            if (validator == null) continue;
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                validator.visit(element, element.getEnclosingElement());
            }
        }
        if (!this.generated) {
            this.model.prepare();
            for (Generator generator : this.generators) {
                generator.generate();
            }
            this.generated = true;
        }
        return true;
    }

    private void addValidator(Validator v) {
        this.elementValidators.put(v.getAnnotationType(), v);
    }

    private void processOptions(Map<String, String> options) {
        if (this.options == null) {
            this.options = options;
            this.shadowPackage = options.get(PACKAGE_OPT);
            boolean bl = this.shouldInstrumentPackages = !"false".equalsIgnoreCase(options.get(SHOULD_INSTRUMENT_PKG_OPT));
            if (this.shadowPackage == null) {
                throw new IllegalArgumentException("no package specified for org.robolectric.annotation.processing.shadowPackage");
            }
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

