/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.robolectric.annotation.processing.DocumentedPackage;
import org.robolectric.annotation.processing.DocumentedType;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.generator.Generator;

public class JavadocJsonGenerator
extends Generator {
    private final RobolectricModel model;
    private final Messager messager;
    private final Gson gson;

    public JavadocJsonGenerator(RobolectricModel model, ProcessingEnvironment environment) {
        this.model = model;
        this.messager = environment.getMessager();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Override
    public void generate() {
        String shadowedType;
        String shadowType;
        HashMap<String, String> shadowedTypes = new HashMap<String, String>();
        for (Map.Entry<TypeElement, TypeElement> entry : this.model.getShadowOfMap().entrySet()) {
            shadowType = entry.getKey().getQualifiedName().toString();
            shadowedType = entry.getValue().getQualifiedName().toString();
            shadowedTypes.put(shadowType, shadowedType);
        }
        for (Map.Entry<Object, Object> entry : this.model.getExtraShadowTypes().entrySet()) {
            shadowType = (String)entry.getKey();
            shadowedType = (String)entry.getValue();
            shadowedTypes.put(shadowType, shadowedType);
        }
        File docs = new File("build/docs/json");
        for (DocumentedPackage documentedPackage : this.model.getDocumentedPackages()) {
            for (DocumentedType documentedType : documentedPackage.getDocumentedTypes()) {
                String shadowedType2 = (String)shadowedTypes.get(documentedType.getName());
                this.writeJson(documentedType, new File(docs, shadowedType2 + ".json"));
            }
        }
    }

    private void writeJson(Object object, File file) {
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write javadoc JSON file: " + e);
            throw new RuntimeException(e);
        }
    }
}

