/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import com.sun.source.tree.ImportTree;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.processing.DocumentedMethod;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.validator.Validator;

public class ImplementsValidator
extends Validator {
    public static final String IMPLEMENTS_CLASS = "org.robolectric.annotation.Implements";
    public static final int MAX_SUPPORTED_ANDROID_SDK = 10000;
    public static final String STATIC_INITIALIZER_METHOD_NAME = "__staticInitializer__";
    public static final String CONSTRUCTOR_METHOD_NAME = "__constructor__";
    private final ProcessingEnvironment env;

    public ImplementsValidator(RobolectricModel model, ProcessingEnvironment env) {
        super(model, env, IMPLEMENTS_CLASS);
        this.env = env;
    }

    private TypeElement getClassNameTypeElement(AnnotationValue cv) {
        String className = RobolectricModel.classNameVisitor.visit(cv);
        TypeElement type = this.elements.getTypeElement(className.replace('$', '.'));
        if (type == null) {
            this.error("@Implements: could not resolve class <" + className + '>', cv);
            return null;
        }
        return type;
    }

    @Override
    public Void visitType(TypeElement elem, Element parent) {
        List<? extends TypeParameterElement> elemTP;
        for (Element element : ElementFilter.methodsIn(elem.getEnclosedElements())) {
            Implementation implementation;
            String methodName = element.getSimpleName().toString();
            if (!methodName.equals(CONSTRUCTOR_METHOD_NAME) && !methodName.equals(STATIC_INITIALIZER_METHOD_NAME) || (implementation = element.getAnnotation(Implementation.class)) != null) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Shadow methods must be annotated @Implementation", element);
        }
        this.captureJavadoc(elem);
        if (elem.getEnclosingElement().getKind() == ElementKind.CLASS && !elem.getModifiers().contains((Object)Modifier.STATIC)) {
            this.error("inner shadow classes must be static");
        }
        this.validateShadowMethods(elem);
        AnnotationMirror am = this.getCurrentAnnotation();
        AnnotationValue annotationValue = RobolectricModel.getAnnotationValue(am, "value");
        AnnotationValue cv = RobolectricModel.getAnnotationValue(am, "className");
        AnnotationValue maxSdk = RobolectricModel.getAnnotationValue(am, "maxSdk");
        if (maxSdk != null && RobolectricModel.intVisitor.visit(maxSdk) < 10000) {
            String sdkClassName = annotationValue == null ? RobolectricModel.classNameVisitor.visit(cv).replace('$', '.') : annotationValue.toString();
            StringBuilder name = new StringBuilder();
            while (elem.getEnclosingElement().getKind() == ElementKind.CLASS) {
                name.insert(0, "$" + elem.getSimpleName().toString());
                elem = (TypeElement)elem.getEnclosingElement();
            }
            name.insert(0, elem.getQualifiedName());
            this.model.addExtraShadow(sdkClassName, name.toString());
            return null;
        }
        TypeElement type = null;
        if (annotationValue == null) {
            if (cv == null) {
                this.error("@Implements: must specify <value> or <className>");
                return null;
            }
            type = this.getClassNameTypeElement(cv);
        } else {
            boolean isAnything;
            TypeMirror value = RobolectricModel.valueVisitor.visit(annotationValue);
            if (value == null) {
                return null;
            }
            boolean bl = isAnything = this.model.ANYTHING_MIRROR != null && this.types.isSameType(value, this.model.ANYTHING_MIRROR);
            if (isAnything) {
                if (cv == null) {
                    this.error("@Implements: Anything class specified but no <className> attribute");
                    return null;
                }
                type = this.getClassNameTypeElement(cv);
            } else if (cv != null) {
                this.error("@Implements: cannot specify both <value> and <className> attributes");
            } else {
                type = RobolectricModel.typeVisitor.visit(this.types.asElement(value));
            }
        }
        if (type == null) {
            return null;
        }
        List<? extends TypeParameterElement> typeTP = type.getTypeParameters();
        if (!this.model.isSameParameterList(typeTP, elemTP = elem.getTypeParameters())) {
            StringBuilder message = new StringBuilder();
            if (elemTP.isEmpty()) {
                message.append("Shadow type is missing type parameters, expected <");
                this.model.appendParameterList(message, type.getTypeParameters());
                message.append('>');
            } else if (typeTP.isEmpty()) {
                message.append("Shadow type has type parameters but real type does not");
            } else {
                message.append("Shadow type must have same type parameters as its real counterpart: expected <");
                this.model.appendParameterList(message, type.getTypeParameters());
                message.append(">, was <");
                this.model.appendParameterList(message, elem.getTypeParameters());
                message.append('>');
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, message, elem);
            return null;
        }
        this.model.addShadowType(elem, type);
        return null;
    }

    private void validateShadowMethods(TypeElement elem) {
        for (Element element : ElementFilter.methodsIn(elem.getEnclosedElements())) {
            ExecutableElement methodElement = (ExecutableElement)element;
            Implementation implementation = element.getAnnotation(Implementation.class);
            String methodName = methodElement.getSimpleName().toString();
            if (!methodName.equals(CONSTRUCTOR_METHOD_NAME) && !methodName.equals(STATIC_INITIALIZER_METHOD_NAME) || implementation != null) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Shadow methods must be annotated @Implementation", methodElement);
        }
    }

    private void captureJavadoc(TypeElement elem) {
        ArrayList<String> imports = new ArrayList<String>();
        List<? extends ImportTree> importLines = Trees.instance(this.env).getPath(elem).getCompilationUnit().getImports();
        for (ImportTree importTree : importLines) {
            imports.add(importTree.getQualifiedIdentifier().toString());
        }
        List<TypeElement> enclosedTypes = ElementFilter.typesIn(elem.getEnclosedElements());
        for (TypeElement enclosedType : enclosedTypes) {
            imports.add(enclosedType.getQualifiedName().toString());
        }
        Elements elements = this.env.getElementUtils();
        this.model.documentType(elem, elements.getDocComment(elem), imports);
        for (Element element : ElementFilter.methodsIn(elem.getEnclosedElements())) {
            ExecutableElement methodElement = (ExecutableElement)element;
            Implementation implementation = element.getAnnotation(Implementation.class);
            DocumentedMethod documentedMethod = new DocumentedMethod(element.toString());
            for (Modifier modifier : element.getModifiers()) {
                documentedMethod.modifiers.add(modifier.toString());
            }
            boolean bl = documentedMethod.isImplementation = implementation != null;
            if (implementation != null) {
                documentedMethod.minSdk = this.sdkOrNull(implementation.minSdk());
                documentedMethod.maxSdk = this.sdkOrNull(implementation.maxSdk());
            }
            for (VariableElement variableElement : methodElement.getParameters()) {
                documentedMethod.params.add(variableElement.toString());
            }
            documentedMethod.returnType = methodElement.getReturnType().toString();
            for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
                documentedMethod.exceptions.add(typeMirror.toString());
            }
            String docMd = elements.getDocComment(methodElement);
            if (docMd != null) {
                documentedMethod.setDocumentation(docMd);
            }
            this.model.documentMethod(elem, documentedMethod);
        }
    }

    private Integer sdkOrNull(int sdk) {
        return sdk == -1 ? null : Integer.valueOf(sdk);
    }
}

