/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.robolectric.annotation.Implements;

public class RobolectricModel {
    private static FQComparator fqComparator = new FQComparator();
    private static SimpleComparator comparator = new SimpleComparator();
    final TypeElement ANYTHING;
    public final TypeMirror ANYTHING_MIRROR;
    final TypeMirror OBJECT_MIRROR;
    final TypeElement IMPLEMENTS;
    final PackageElement JAVA_LANG;
    private final Elements elements;
    private final Types types;
    private HashMap<TypeElement, String> referentMap = Maps.newHashMap();
    private HashMultimap<String, TypeElement> typeMap = HashMultimap.create();
    private HashMap<TypeElement, TypeElement> importMap = Maps.newHashMap();
    private TreeMap<TypeElement, TypeElement> shadowTypes = Maps.newTreeMap((Comparator)fqComparator);
    private TreeSet<String> imports = Sets.newTreeSet();
    private TreeMap<TypeElement, ExecutableElement> resetterMap = Maps.newTreeMap((Comparator)comparator);
    public static ElementVisitor<TypeElement, Void> typeVisitor = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };
    public static AnnotationValueVisitor<TypeMirror, Void> valueVisitor = new SimpleAnnotationValueVisitor6<TypeMirror, Void>(){

        @Override
        public TypeMirror visitType(TypeMirror t, Void arg) {
            return t;
        }
    };
    public static AnnotationValueVisitor<String, Void> classNameVisitor = new SimpleAnnotationValueVisitor6<String, Void>(){

        @Override
        public String visitString(String s, Void arg) {
            return s;
        }
    };
    private static ElementVisitor<TypeElement, Void> typeElementVisitor = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };
    private Predicate<TypeMirror> notObject;
    private TypeVisitor<String, Void> findReferent = new SimpleTypeVisitor6<String, Void>(){

        @Override
        public String visitDeclared(DeclaredType t, Void p) {
            return (String)RobolectricModel.this.referentMap.get(t.asElement());
        }
    };
    private Equivalence<TypeMirror> typeMirrorEq = new Equivalence<TypeMirror>(){

        protected boolean doEquivalent(TypeMirror a, TypeMirror b) {
            return RobolectricModel.this.types.isSameType(a, b);
        }

        protected int doHash(TypeMirror t) {
            return 0;
        }
    };
    private Equivalence<TypeParameterElement> typeEq = new Equivalence<TypeParameterElement>(){

        protected boolean doEquivalent(TypeParameterElement arg0, TypeParameterElement arg1) {
            return RobolectricModel.this.typeMirrorEq.pairwise().equivalent(arg0.getBounds(), arg1.getBounds());
        }

        protected int doHash(TypeParameterElement arg0) {
            return 0;
        }
    };

    public RobolectricModel(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.ANYTHING = elements.getTypeElement("org.robolectric.Robolectric.Anything");
        this.ANYTHING_MIRROR = this.ANYTHING == null ? null : this.ANYTHING.asType();
        this.IMPLEMENTS = elements.getTypeElement("org.robolectric.annotation.Implements");
        this.JAVA_LANG = elements.getPackageElement("java.lang");
        this.OBJECT_MIRROR = elements.getTypeElement(Object.class.getCanonicalName()).asType();
        this.notObject = new Predicate<TypeMirror>(){

            public boolean apply(TypeMirror t) {
                return !RobolectricModel.this.types.isSameType(t, RobolectricModel.this.OBJECT_MIRROR);
            }
        };
    }

    public AnnotationMirror getAnnotationMirror(Element element, TypeElement annotation) {
        TypeMirror expectedType = annotation.asType();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(expectedType, annotationMirror.getAnnotationType())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public AnnotationMirror getImplementsMirror(Element elem) {
        return this.getAnnotationMirror(elem, this.IMPLEMENTS);
    }

    private TypeMirror getImplementedClassName(AnnotationMirror am) {
        AnnotationValue className = RobolectricModel.getAnnotationValue(am, "className");
        if (className == null) {
            return null;
        }
        String classNameString = classNameVisitor.visit(className);
        if (classNameString == null) {
            return null;
        }
        TypeElement impElement = this.elements.getTypeElement(classNameString.replace('$', '.'));
        if (impElement == null) {
            return null;
        }
        return impElement.asType();
    }

    public TypeMirror getImplementedClass(AnnotationMirror am) {
        if (am == null) {
            return null;
        }
        TypeMirror impType = this.getImplementedClassName(am);
        if (impType != null) {
            return impType;
        }
        AnnotationValue av = RobolectricModel.getAnnotationValue(am, "value");
        if (av == null) {
            return null;
        }
        TypeMirror type = valueVisitor.visit(av);
        if (type == null) {
            return null;
        }
        if (this.ANYTHING_MIRROR != null && this.types.isSameType(type, this.ANYTHING_MIRROR)) {
            return null;
        }
        return type;
    }

    private void registerType(TypeElement type) {
        if (!Objects.equal((Object)this.ANYTHING, (Object)type) && !this.importMap.containsKey(type)) {
            this.typeMap.put((Object)type.getSimpleName().toString(), (Object)type);
            this.importMap.put(type, type);
            for (TypeParameterElement typeParameterElement : type.getTypeParameters()) {
                for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                    TypeElement boundElement = typeElementVisitor.visit(this.types.asElement(typeMirror));
                    this.registerType(boundElement);
                }
            }
        }
    }

    public void prepare() {
        for (Map.Entry<TypeElement, TypeElement> entry : this.getVisibleShadowTypes().entrySet()) {
            TypeElement typeElement = entry.getKey();
            this.registerType(typeElement);
            TypeElement solidType = entry.getValue();
            this.registerType(solidType);
        }
        for (Map.Entry<TypeElement, TypeElement> entry : this.getResetterShadowTypes().entrySet()) {
            TypeElement typeElement = entry.getKey();
            this.registerType(typeElement);
        }
        while (!this.typeMap.isEmpty()) {
            final HashMultimap nextRound = HashMultimap.create();
            for (Map.Entry entry : Multimaps.asMap(this.typeMap).entrySet()) {
                Set c = (Set)entry.getValue();
                if (c.size() == 1) {
                    TypeElement type = (TypeElement)c.iterator().next();
                    this.referentMap.put(type, (String)entry.getKey());
                    continue;
                }
                for (TypeElement type : c) {
                    SimpleElementVisitor6<Void, TypeElement> visitor = new SimpleElementVisitor6<Void, TypeElement>(){

                        @Override
                        public Void visitType(TypeElement parent, TypeElement type) {
                            nextRound.put((Object)(parent.getSimpleName() + "." + type.getSimpleName()), (Object)type);
                            RobolectricModel.this.importMap.put(type, parent);
                            return null;
                        }

                        @Override
                        public Void visitPackage(PackageElement parent, TypeElement type) {
                            RobolectricModel.this.referentMap.put(type, type.getQualifiedName().toString());
                            RobolectricModel.this.importMap.remove(type);
                            return null;
                        }
                    };
                    visitor.visit(this.importMap.get(type).getEnclosingElement(), type);
                }
            }
            this.typeMap = nextRound;
        }
        for (TypeElement typeElement : this.importMap.values()) {
            if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC) || this.JAVA_LANG.equals(typeElement.getEnclosingElement())) continue;
            this.imports.add(typeElement.getQualifiedName().toString());
        }
        this.imports.add("java.util.Map");
        this.imports.add("java.util.HashMap");
        this.imports.add("javax.annotation.Generated");
        this.imports.add("org.robolectric.internal.ShadowExtractor");
        this.imports.add("org.robolectric.internal.ShadowProvider");
    }

    public void addShadowType(TypeElement elem, TypeElement type) {
        this.shadowTypes.put(elem, type);
    }

    public void addResetter(TypeElement parent, ExecutableElement elem) {
        this.resetterMap.put(parent, elem);
    }

    public Set<Map.Entry<TypeElement, ExecutableElement>> getResetters() {
        return this.resetterMap.entrySet();
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public Map<TypeElement, TypeElement> getAllShadowTypes() {
        return this.shadowTypes;
    }

    public Map<TypeElement, TypeElement> getResetterShadowTypes() {
        return Maps.filterEntries(this.shadowTypes, (Predicate)new Predicate<Map.Entry<TypeElement, TypeElement>>(){

            public boolean apply(Map.Entry<TypeElement, TypeElement> entry) {
                return RobolectricModel.this.resetterMap.containsKey(entry.getKey());
            }
        });
    }

    public Map<TypeElement, TypeElement> getVisibleShadowTypes() {
        return Maps.filterEntries(this.shadowTypes, (Predicate)new Predicate<Map.Entry<TypeElement, TypeElement>>(){

            public boolean apply(Map.Entry<TypeElement, TypeElement> entry) {
                return entry.getKey().getAnnotation(Implements.class).isInAndroidSdk();
            }
        });
    }

    public Map<TypeElement, TypeElement> getShadowOfMap() {
        return Maps.filterEntries(this.getVisibleShadowTypes(), (Predicate)new Predicate<Map.Entry<TypeElement, TypeElement>>(){

            public boolean apply(Map.Entry<TypeElement, TypeElement> entry) {
                return !Objects.equal((Object)RobolectricModel.this.ANYTHING, (Object)entry.getValue());
            }
        });
    }

    public Collection<String> getShadowedPackages() {
        HashSet<String> packages = new HashSet<String>();
        for (TypeElement element : this.getVisibleShadowTypes().values()) {
            packages.add("\"" + this.elements.getPackageOf(element).toString() + "\"");
        }
        return packages;
    }

    public List<TypeMirror> getExplicitBounds(TypeParameterElement typeParam) {
        return Lists.newArrayList((Iterable)Iterables.filter(typeParam.getBounds(), this.notObject));
    }

    public String getReferentFor(TypeElement type) {
        return this.referentMap.get(type);
    }

    public String getReferentFor(TypeMirror type) {
        return this.findReferent.visit(type);
    }

    public void appendParameterList(StringBuilder message, List<? extends TypeParameterElement> tpeList) {
        boolean first = true;
        for (TypeParameterElement typeParameterElement : tpeList) {
            if (first) {
                first = false;
            } else {
                message.append(',');
            }
            message.append(typeParameterElement.toString());
            boolean iFirst = true;
            for (TypeMirror bound : this.getExplicitBounds(typeParameterElement)) {
                if (iFirst) {
                    message.append(" extends ");
                    iFirst = false;
                } else {
                    message.append(',');
                }
                message.append(bound);
            }
        }
    }

    public boolean isSameParameterList(List<? extends TypeParameterElement> l1, List<? extends TypeParameterElement> l2) {
        return this.typeEq.pairwise().equivalent(l1, l2);
    }

    private static class SimpleComparator
    implements Comparator<Element> {
        private SimpleComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            return o1.getSimpleName().toString().compareTo(o2.getSimpleName().toString());
        }
    }

    private static class FQComparator
    implements Comparator<TypeElement> {
        private FQComparator() {
        }

        @Override
        public int compare(TypeElement o1, TypeElement o2) {
            return o1.getQualifiedName().toString().compareTo(o2.getQualifiedName().toString());
        }
    }
}

