/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.generator;

import com.google.common.base.Joiner;
import java.io.PrintWriter;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.RobolectricProcessor;
import org.robolectric.annotation.processing.generator.Generator;

public class ShadowProviderGenerator
extends Generator {
    private final Filer filer;
    private final Messager messager;
    private final Elements elements;
    private final RobolectricModel model;
    private final boolean shouldInstrumentPackages;

    public ShadowProviderGenerator(RobolectricModel model, ProcessingEnvironment environment, boolean shouldInstrumentPackages) {
        this.messager = environment.getMessager();
        this.elements = environment.getElementUtils();
        this.filer = environment.getFiler();
        this.model = model;
        this.shouldInstrumentPackages = shouldInstrumentPackages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(String shadowPackage) {
        String shadowClassName = shadowPackage + '.' + "Shadows";
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Generating output file: " + shadowClassName);
        try (PrintWriter writer = null;){
            void var6_14;
            JavaFileObject jfo = this.filer.createSourceFile(shadowClassName, new Element[0]);
            writer = new PrintWriter(jfo.openWriter());
            writer.print("package " + shadowPackage + ";\n");
            for (String string : this.model.getImports()) {
                writer.println("import " + string + ';');
            }
            writer.println();
            writer.println("/**");
            writer.println(" * Shadow mapper. Automatically generated by the Robolectric Annotation Processor.");
            writer.println(" */");
            writer.println("@Generated(\"" + RobolectricProcessor.class.getCanonicalName() + "\")");
            writer.println("@SuppressWarnings({\"unchecked\",\"deprecation\"})");
            writer.println("public class Shadows implements ShadowProvider {");
            int shadowSize = this.model.getAllShadowTypes().size();
            writer.println("  private static final Map<String, String> SHADOW_MAP = new HashMap<>(" + shadowSize + ");");
            writer.println();
            writer.println("  static {");
            for (Map.Entry<TypeElement, TypeElement> entry : this.model.getAllShadowTypes().entrySet()) {
                String shadow = this.elements.getBinaryName(entry.getKey()).toString();
                String actual = entry.getValue().getQualifiedName().toString();
                writer.println("    SHADOW_MAP.put(\"" + actual + "\", \"" + shadow + "\");");
            }
            writer.println("  }");
            writer.println();
            for (Map.Entry<TypeElement, TypeElement> entry : this.model.getShadowOfMap().entrySet()) {
                void var13_26;
                TypeElement actualType = entry.getValue();
                if (!actualType.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                int paramCount = 0;
                StringBuilder paramDef = new StringBuilder("<");
                StringBuilder paramUse = new StringBuilder("<");
                for (TypeParameterElement typeParameterElement : entry.getValue().getTypeParameters()) {
                    if (paramCount > 0) {
                        paramDef.append(',');
                        paramUse.append(',');
                    }
                    boolean first = true;
                    paramDef.append(typeParameterElement);
                    paramUse.append(typeParameterElement);
                    for (TypeMirror bound : this.model.getExplicitBounds(typeParameterElement)) {
                        if (first) {
                            paramDef.append(" extends ");
                            first = false;
                        } else {
                            paramDef.append(" & ");
                        }
                        paramDef.append(this.model.getReferentFor(bound));
                    }
                    ++paramCount;
                }
                String paramDefStr = "";
                String string = "";
                if (paramCount > 0) {
                    paramDefStr = paramDef.append("> ").toString();
                    String string2 = paramUse.append('>').toString();
                }
                String actual = this.model.getReferentFor(actualType) + (String)var13_26;
                String shadow = this.model.getReferentFor(entry.getKey()) + (String)var13_26;
                writer.println("  public static " + paramDefStr + shadow + " shadowOf(" + actual + " actual) {");
                writer.println("    return (" + shadow + ") ShadowExtractor.extract(actual);");
                writer.println("  }");
                writer.println();
            }
            writer.println("  public void reset() {");
            for (Map.Entry<TypeElement, ExecutableElement> entry : this.model.getResetters()) {
                writer.println("    " + this.model.getReferentFor(entry.getKey()) + "." + entry.getValue().getSimpleName() + "();");
            }
            writer.println("  }");
            writer.println();
            writer.println("  @Override");
            writer.println("  public Map<String, String> getShadowMap() {");
            writer.println("    return SHADOW_MAP;");
            writer.println("  }");
            writer.println();
            writer.println("  @Override");
            writer.println("  public String[] getProvidedPackageNames() {");
            String string = "";
            if (this.shouldInstrumentPackages) {
                String string3 = Joiner.on((String)",").join(this.model.getShadowedPackages());
            }
            writer.println("    return new String[] {" + (String)var6_14 + "};");
            writer.println("  }");
            writer.println('}');
        }
    }
}

