/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.validator.FoundOnImplementsValidator;

public class RealObjectValidator
extends FoundOnImplementsValidator {
    TypeVisitor<Void, VariableElement> typeVisitor = new SimpleTypeVisitor6<Void, VariableElement>(){

        @Override
        public Void visitDeclared(DeclaredType t, VariableElement v) {
            List<? extends TypeMirror> typeParams = t.getTypeArguments();
            List<? extends TypeParameterElement> parentTypeParams = RealObjectValidator.this.parent.getTypeParameters();
            if (!parentTypeParams.isEmpty() && typeParams.isEmpty()) {
                RealObjectValidator.this.messager.printMessage(Diagnostic.Kind.ERROR, "@RealObject is missing type parameters", v);
            } else {
                String parentString;
                String typeString = RealObjectValidator.join(typeParams);
                if (!typeString.equals(parentString = RealObjectValidator.join(parentTypeParams))) {
                    RealObjectValidator.this.messager.printMessage(Diagnostic.Kind.ERROR, "Parameter type mismatch: expecting <" + parentString + ">, was <" + typeString + '>', v);
                }
            }
            return null;
        }
    };
    TypeElement parent;

    public RealObjectValidator(RobolectricModel model, ProcessingEnvironment env) {
        super(model, env, "org.robolectric.annotation.RealObject");
    }

    public static String join(List<?> params) {
        StringBuffer retval = new StringBuffer();
        boolean comma = false;
        for (Object p : params) {
            if (comma) {
                retval.append(',');
            }
            comma = true;
            retval.append(p);
        }
        return retval.toString();
    }

    @Override
    public Void visitVariable(VariableElement elem, TypeElement parent) {
        this.parent = parent;
        TypeMirror impClass = this.model.getImplementedClass(this.imp);
        if (impClass != null) {
            TypeMirror elemType = elem.asType();
            if (!this.types.isAssignable(impClass, elemType)) {
                this.error("@RealObject with type <" + elemType + ">; expected <" + impClass + '>');
            }
            this.typeVisitor.visit(elemType, elem);
        }
        return null;
    }
}

