/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.generator;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.generator.Generator;

public class ServiceLoaderGenerator
extends Generator {
    private final Filer filer;
    private final Messager messager;
    private final RobolectricModel model;

    public ServiceLoaderGenerator(RobolectricModel model, ProcessingEnvironment environment) {
        this.filer = environment.getFiler();
        this.messager = environment.getMessager();
        this.model = model;
    }

    @Override
    public void generate(String shadowPackage) {
        String fileName = "org.robolectric.internal.ShadowProvider";
        try {
            FileObject file = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org.robolectric.internal.ShadowProvider", new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));
            pw.println(shadowPackage + '.' + "Shadows");
            pw.close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write service loader metadata file: " + e);
            throw new RuntimeException(e);
        }
    }
}

